/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.services.workspace.plugin.forms.AcceptWorkspaceInvitationFormFilter;
import org.osivia.services.workspace.plugin.forms.DeclineWorkspaceInvitationFormFilter;
import org.osivia.services.workspace.plugin.menubar.MemberManagementMenubarModule;
import org.osivia.services.workspace.plugin.portlet.ManageableWorkspacesListTemplateModule;
import org.osivia.services.workspace.plugin.portlet.RequestsListTemplateModule;

public class MemberManagementPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "workspace-member-management.plugin";
    private final MenubarModule menubarModule = new MemberManagementMenubarModule();
    private final IBundleFactory bundleFactory;

    public MemberManagementPlugin() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(String customizationId, CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        List menubarModules = this.getMenubarModules(context);
        menubarModules.add(this.menubarModule);
        Map formFilters = this.getFormFilters(context);
        formFilters.put("ACCEPT_WORKSPACE_INVITATION", new AcceptWorkspaceInvitationFormFilter(portletContext));
        formFilters.put("DECLINE_WORKSPACE_INVITATION", new DeclineWorkspaceInvitationFormFilter());
        this.customizeListTemplates(context);
    }

    private void customizeListTemplates(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        Map templates = this.getListTemplates(context);
        ListTemplate manageableWorkspaces = new ListTemplate("manageable-workspaces", bundle.getString("LIST_TEMPLATE_MANAGEABLE_WORKSPACES"), "dublincore, toutatice, toutatice_space");
        manageableWorkspaces.setModule((IPortletModule)new ManageableWorkspacesListTemplateModule(portletContext));
        templates.put(manageableWorkspaces.getKey(), manageableWorkspaces);
        ListTemplate requests = new ListTemplate("workspace-member-requests", bundle.getString("LIST_TEMPLATE_WORKSPACE_MEMBER_REQUESTS"), "dublincore, toutatice, toutatice_space, webcontainer");
        requests.setModule((IPortletModule)new RequestsListTemplateModule(portletContext));
        templates.put(requests.getKey(), requests);
    }
}

