/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.batch.AbstractBatch;
import org.osivia.portal.api.batch.IBatchService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.workspace.batch.ImportInvitationsBatch;
import org.osivia.services.workspace.batch.ImportObject;
import org.osivia.services.workspace.portlet.model.AbstractAddToGroupForm;
import org.osivia.services.workspace.portlet.model.AbstractChangeRoleForm;
import org.osivia.services.workspace.portlet.model.AbstractMembersForm;
import org.osivia.services.workspace.portlet.model.AddInvitationsToGroupForm;
import org.osivia.services.workspace.portlet.model.AddMembersToGroupForm;
import org.osivia.services.workspace.portlet.model.ChangeInvitationRequestsRoleForm;
import org.osivia.services.workspace.portlet.model.ChangeInvitationsRoleForm;
import org.osivia.services.workspace.portlet.model.ChangeMembersRoleForm;
import org.osivia.services.workspace.portlet.model.ImportForm;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationEditionForm;
import org.osivia.services.workspace.portlet.model.InvitationObject;
import org.osivia.services.workspace.portlet.model.InvitationRequest;
import org.osivia.services.workspace.portlet.model.InvitationRequestsForm;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.model.InvitationsCreationForm;
import org.osivia.services.workspace.portlet.model.InvitationsForm;
import org.osivia.services.workspace.portlet.model.Member;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MemberObject;
import org.osivia.services.workspace.portlet.model.MembersForm;
import org.osivia.services.workspace.portlet.model.MembersSort;
import org.osivia.services.workspace.portlet.model.ResendInvitationsForm;
import org.osivia.services.workspace.portlet.model.comparator.InvitationObjectComparator;
import org.osivia.services.workspace.portlet.model.comparator.LocalGroupComparator;
import org.osivia.services.workspace.portlet.model.comparator.MemberObjectComparator;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.osivia.services.workspace.util.ApplicationContextProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MemberManagementServiceImpl
implements MemberManagementService,
ApplicationContextAware {
    private static final String MAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private ApplicationContext applicationContext;
    @Autowired
    private MemberManagementRepository repository;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private IBatchService batchService;
    @Autowired
    private LocalGroupComparator localGroupComparator;
    private final Pattern mailPattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private final Log log = LogFactory.getLog(this.getClass());

    public MemberManagementOptions getOptions(PortalControllerContext portalControllerContext) throws PortletException {
        MemberManagementOptions options = (MemberManagementOptions)this.applicationContext.getBean(MemberManagementOptions.class);
        if (options.getWorkspaceId() == null) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            options.setWorkspaceId(workspaceId);
            WorkspaceType type = this.repository.getCurrentWorkspaceType(portalControllerContext);
            options.setWorkspaceType(type);
            int invitationsCount = this.repository.getInvitationsCount(portalControllerContext, workspaceId);
            options.setInvitationsCount(invitationsCount);
            if (!WorkspaceType.INVITATION.equals((Object)type)) {
                int requestsCount = this.repository.getRequestsCount(portalControllerContext, workspaceId);
                options.setRequestsCount(requestsCount);
            }
            List roles = this.repository.getRoles(portalControllerContext, workspaceId);
            options.setRoles(roles);
            List localGroups = this.repository.getLocalGroups(portalControllerContext, workspaceId);
            Collections.sort(localGroups, this.localGroupComparator);
            options.setWorkspaceLocalGroups(localGroups);
        }
        return options;
    }

    public MembersForm getMembersForm(PortalControllerContext portalControllerContext) throws PortletException {
        MembersForm form = (MembersForm)this.applicationContext.getBean(MembersForm.class);
        if (!form.isLoaded()) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            List members = this.repository.getMembers(portalControllerContext, workspaceId);
            form.setMembers(members);
            HashSet<String> identifiers = new HashSet<String>();
            for (Member member : members) {
                identifiers.add(member.getId());
            }
            form.setIdentifiers(identifiers);
            this.sortMembers(portalControllerContext, (AbstractMembersForm)form, MembersSort.DATE, true);
            form.setLoaded(true);
        }
        return form;
    }

    public void sortMembers(PortalControllerContext portalControllerContext, AbstractMembersForm<? extends MemberObject> form, MembersSort sort, boolean alt) throws PortletException {
        if (CollectionUtils.isNotEmpty((Collection)form.getMembers())) {
            MemberObjectComparator comparator = (MemberObjectComparator)this.applicationContext.getBean(MemberObjectComparator.class, new Object[]{sort, alt});
            try {
                Collections.sort(form.getMembers(), comparator);
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)"Impossible de trier les membres ", (Throwable)e);
            }
            form.setSort(sort);
            form.setAlt(alt);
        }
    }

    public void removeMembers(PortalControllerContext portalControllerContext, MemberManagementOptions options, MembersForm form, String[] identifiers) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        HashSet<String> sortedIdentifiers = new HashSet<String>(Arrays.asList(identifiers));
        ArrayList<Member> removedMembers = new ArrayList<Member>(sortedIdentifiers.size());
        for (Member member : form.getMembers()) {
            if (!sortedIdentifiers.contains(member.getId()) || !member.isEditable()) continue;
            member.setDeleted(true);
            this.repository.updateMember(portalControllerContext, workspaceId, member);
            removedMembers.add(member);
        }
        form.getMembers().removeAll(removedMembers);
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_REMOVE_MEMBERS_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public String getMembersHelp(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getHelp(portalControllerContext, "workspace-member-management.members.help.location");
    }

    public Element getMembersToolbar(PortalControllerContext portalControllerContext, List<String> indexes) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Element container = DOM4JUtils.generateDivElement(null);
        Element toolbar = DOM4JUtils.generateDivElement((String)"btn-toolbar", (AccessibilityRoles)AccessibilityRoles.TOOLBAR);
        container.add(toolbar);
        if (CollectionUtils.isNotEmpty(indexes)) {
            MembersForm form = this.getMembersForm(portalControllerContext);
            List members = form.getMembers();
            ArrayList<Member> selectedMembers = new ArrayList<Member>(indexes.size());
            for (String index : indexes) {
                int i = NumberUtils.toInt((String)index, (int)-1);
                if (i <= -1 || i >= members.size()) continue;
                Member member = (Member)members.get(i);
                selectedMembers.add(member);
            }
            if (indexes.size() == selectedMembers.size()) {
                boolean allEditable;
                Member member;
                Iterator iterator = selectedMembers.iterator();
                for (allEditable = true; allEditable && iterator.hasNext(); allEditable &= member.isEditable()) {
                    member = (Member)iterator.next();
                }
                String[] identifiers = new String[selectedMembers.size()];
                for (int i = 0; i < selectedMembers.size(); ++i) {
                    Member member2 = (Member)selectedMembers.get(i);
                    identifiers[i] = member2.getId();
                }
                String tab = "members";
                Element changeRole = this.getChangeRoleToolbarButton(portalControllerContext, identifiers, allEditable, tab, bundle);
                toolbar.add(changeRole);
                Element addToGroup = this.getAddToGroupToolbarButton(portalControllerContext, identifiers, tab, bundle);
                toolbar.add(addToGroup);
                Element removeMember = this.getRemoveMemberToolbarButton(portalControllerContext, allEditable, bundle);
                toolbar.add(removeMember);
                if (allEditable) {
                    Element removeMemberConfirmationModal = this.getRemoveMemberConfirmationModal(portalControllerContext, selectedMembers, identifiers, bundle);
                    container.add(removeMemberConfirmationModal);
                }
            }
        }
        return container;
    }

    protected Element getChangeRoleToolbarButton(PortalControllerContext portalControllerContext, String[] identifiers, boolean allEditable, String tab, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String htmlClass = "btn btn-default btn-sm";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_CHANGE_ROLE");
        String icon = "glyphicons glyphicons-shield";
        if (allEditable && mimeResponse != null) {
            PortletURL renderUrl = mimeResponse.createRenderURL();
            renderUrl.setParameter("tab", tab);
            renderUrl.setParameter("view", "change-role");
            renderUrl.setParameter("identifiers", identifiers);
            url = renderUrl.toString();
        } else {
            url = null;
        }
        if (StringUtils.isEmpty(url)) {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        return DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
    }

    protected Element getAddToGroupToolbarButton(PortalControllerContext portalControllerContext, String[] identifiers, String tab, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String htmlClass = "btn btn-default btn-sm";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ADD_TO_GROUP");
        String icon = "glyphicons glyphicons-group";
        if (mimeResponse != null) {
            PortletURL renderUrl = mimeResponse.createRenderURL();
            renderUrl.setParameter("tab", tab);
            renderUrl.setParameter("view", "add-to-group");
            renderUrl.setParameter("identifiers", identifiers);
            url = renderUrl.toString();
        } else {
            url = null;
        }
        if (StringUtils.isEmpty(url)) {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        return DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
    }

    protected Element getRemoveMemberToolbarButton(PortalControllerContext portalControllerContext, boolean allEditable, Bundle bundle) {
        String url;
        PortletResponse response = portalControllerContext.getResponse();
        String htmlClass = "btn btn-default btn-sm no-ajax-link";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_REMOVE_MEMBER");
        String icon = "glyphicons glyphicons-remove";
        if (allEditable) {
            url = "#" + response.getNamespace() + "-remove";
        } else {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        Element button = DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
        if (allEditable) {
            DOM4JUtils.addDataAttribute((Element)button, (String)"toggle", (String)"modal");
        }
        return button;
    }

    protected Element getRemoveMemberConfirmationModal(PortalControllerContext portalControllerContext, List<Member> selectedMembers, String[] identifiers, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String modalId = portletResponse.getNamespace() + "-remove";
        String title = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_REMOVE_MEMBER");
        Element content = DOM4JUtils.generateDivElement(null);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_REMOVE_MEMBER_MODAL_MESSAGE"));
        content.add(message);
        Element ul = this.getSelectionModalBodyContent(selectedMembers, bundle);
        content.add(ul);
        if (mimeResponse == null) {
            url = "#";
        } else {
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "remove");
            actionUrl.setParameter("tab", "members");
            actionUrl.setParameter("identifiers", identifiers);
            url = actionUrl.toString();
        }
        Element confirm = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-danger no-ajax-link", (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_REMOVE_MEMBER"), null);
        return this.getConfirmationModal(portalControllerContext, modalId, title, content, confirm, bundle);
    }

    protected Element getSelectionModalBodyContent(List<? extends MemberObject> selection, Bundle bundle) {
        Element ul = DOM4JUtils.generateElement((String)"ul", null, null);
        for (MemberObject memberObject : selection) {
            String message;
            Element li = DOM4JUtils.generateElement((String)"li", null, null);
            ul.add(li);
            Element p = DOM4JUtils.generateElement((String)"p", null, null);
            li.add(p);
            String avatarUrl = memberObject.getPerson().getAvatar() == null ? null : memberObject.getPerson().getAvatar().getUrl();
            if (StringUtils.isNotEmpty(avatarUrl)) {
                Element avatar = DOM4JUtils.generateElement((String)"img", (String)"avatar", null);
                DOM4JUtils.addAttribute((Element)avatar, (String)"src", (String)avatarUrl);
                DOM4JUtils.addAttribute((Element)avatar, (String)"alt", (String)"");
                p.add(avatar);
            }
            Element displayName = DOM4JUtils.generateElement((String)"span", null, (String)memberObject.getDisplayName());
            p.add(displayName);
            if (memberObject.getRole() != null) {
                String text = bundle.getString(memberObject.getRole().getKey(), memberObject.getRole().getClassLoader(), new Object[0]);
                Element role = DOM4JUtils.generateElement((String)"small", (String)"text-muted", (String)text);
                p.add(role);
            }
            if (memberObject instanceof Invitation) {
                Invitation invitation = (Invitation)memberObject;
                message = invitation.getMessage();
            } else if (memberObject instanceof InvitationRequest) {
                InvitationRequest request = (InvitationRequest)memberObject;
                message = request.getUserMessage();
            } else {
                message = null;
            }
            if (!StringUtils.isNotBlank((String)message)) continue;
            Element blockquote = DOM4JUtils.generateElement((String)"blockquote", null, null);
            li.add(blockquote);
            Element userMessage = DOM4JUtils.generateElement((String)"p", (String)"text-pre-wrap", (String)message);
            blockquote.add(userMessage);
        }
        return ul;
    }

    protected Element getConfirmationModal(PortalControllerContext portalControllerContext, String modalId, String title, Element content, Element confirm, Bundle bundle) {
        Element modal = DOM4JUtils.generateDivElement((String)"modal fade");
        DOM4JUtils.addAttribute((Element)modal, (String)"id", (String)modalId);
        Element modalDialog = DOM4JUtils.generateDivElement((String)"modal-dialog");
        modal.add(modalDialog);
        Element modalContent = DOM4JUtils.generateDivElement((String)"modal-content");
        modalDialog.add(modalContent);
        Element modalHeader = DOM4JUtils.generateDivElement((String)"modal-header");
        modalContent.add(modalHeader);
        Element close = DOM4JUtils.generateElement((String)"button", (String)"close", null, (String)"glyphicons glyphicons-remove", null);
        DOM4JUtils.addAttribute((Element)close, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)close, (String)"dismiss", (String)"modal");
        modalHeader.add(close);
        Element modalTitle = DOM4JUtils.generateElement((String)"h4", (String)"modal-title", (String)title);
        modalHeader.add(modalTitle);
        Element modalBody = DOM4JUtils.generateDivElement((String)"modal-body");
        modalContent.add(modalBody);
        modalBody.add(content);
        Element modalFooter = DOM4JUtils.generateDivElement((String)"modal-footer");
        modalContent.add(modalFooter);
        modalFooter.add(confirm);
        Element cancel = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("CANCEL"), null, null);
        DOM4JUtils.addAttribute((Element)cancel, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)cancel, (String)"dismiss", (String)"modal");
        modalFooter.add(cancel);
        return modal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMembersCsv(PortalControllerContext portalControllerContext, MembersForm members, OutputStream outputStream) throws PortletException, IOException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YYYY");
        try {
            CSVFormat format = CSVFormat.EXCEL;
            ArrayList<String> headers = new ArrayList<String>();
            headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER"));
            headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER_EXTRA"));
            headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_MEMBER_ACKNOWLEDGMENT_DATE"));
            headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ROLE"));
            headers.add(bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ID"));
            format.withHeader(headers.toArray(new String[headers.size()]));
            CSVPrinter printer = format.print((Appendable)writer);
            try {
                for (Member member : members.getMembers()) {
                    String date = member.getDate() == null ? "" : dateFormat.format(member.getDate());
                    String role = member.getRole() == null ? "" : bundle.getString(member.getRole().getKey(), member.getRole().getClassLoader(), new Object[0]);
                    printer.printRecord(new Object[]{member.getDisplayName(), member.getExtra(), date, role, member.getId()});
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)printer);
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected List<Member> getSelectedMembers(PortalControllerContext portalControllerContext, String[] identifiers) throws PortletException {
        ArrayList<Member> selectedMembers;
        List members = this.getMembersForm(portalControllerContext).getMembers();
        if (ArrayUtils.isEmpty((Object[])identifiers) || CollectionUtils.isEmpty((Collection)members)) {
            selectedMembers = null;
        } else {
            HashMap<String, Member> sortedMembers = new HashMap<String, Member>(members.size());
            for (Member member : members) {
                sortedMembers.put(member.getId(), member);
            }
            selectedMembers = new ArrayList<Member>(identifiers.length);
            for (String identifier : identifiers) {
                Member member = (Member)sortedMembers.get(identifier);
                if (member == null) continue;
                selectedMembers.add(member);
            }
        }
        return selectedMembers;
    }

    public InvitationsForm getInvitationsForm(PortalControllerContext portalControllerContext) throws PortletException {
        InvitationsForm form = (InvitationsForm)this.applicationContext.getBean(InvitationsForm.class);
        if (!form.isLoaded()) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            Set identifiers = this.getMembersForm(portalControllerContext).getIdentifiers();
            List invitations = this.repository.getInvitations(portalControllerContext, workspaceId, identifiers);
            form.setInvitations(invitations);
            HashSet<String> invitationIdentifiers = new HashSet<String>();
            boolean purgeAvailable = false;
            for (Invitation invitation : invitations) {
                if (InvitationState.SENT.equals((Object)invitation.getState())) {
                    invitationIdentifiers.add(invitation.getId());
                    continue;
                }
                purgeAvailable = true;
            }
            form.setIdentifiers(invitationIdentifiers);
            form.setPurgeAvailable(purgeAvailable);
            this.sortInvitations(portalControllerContext, form, MembersSort.DATE, true);
            form.setLoaded(true);
        }
        return form;
    }

    public InvitationsCreationForm getInvitationsCreationForm(PortalControllerContext portalControllerContext) throws PortletException {
        InvitationsCreationForm form = (InvitationsCreationForm)this.applicationContext.getBean(InvitationsCreationForm.class);
        form.setRole(WorkspaceRole.READER);
        return form;
    }

    public JSONObject searchPersons(PortalControllerContext portalControllerContext, MemberManagementOptions options, String filter, int page, boolean tokenizer) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        boolean invitationOnly = WorkspaceType.INVITATION.equals((Object)options.getWorkspaceType());
        Set memberIdentifiers = this.getMembersForm(portalControllerContext).getIdentifiers();
        Set invitationIndentifiers = this.getInvitationsForm(portalControllerContext).getIdentifiers();
        Set requestIdentifiers = invitationOnly ? null : this.getInvitationRequestsForm(portalControllerContext).getIdentifiers();
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        int total = 0;
        String[] parts = StringUtils.isBlank((String)filter) ? new String[]{""} : StringUtils.split((String)filter, (String)",;");
        for (String part : parts) {
            List persons = this.repository.searchPersons(portalControllerContext, part, tokenizer);
            for (Person person : persons) {
                boolean alreadyMember = memberIdentifiers.contains(person.getUid());
                boolean alreadyInvited = invitationIndentifiers.contains(person.getUid());
                boolean existingRequest = !invitationOnly && requestIdentifiers.contains(person.getUid());
                JSONObject object = this.getSearchResult(person, alreadyMember, alreadyInvited, existingRequest, bundle);
                objects.add(object);
                ++total;
            }
            if (!this.enablePersonCreation() || tokenizer && !persons.isEmpty()) continue;
            this.addPersonCreationSearchResult(persons, objects, part, bundle);
        }
        JSONObject results = new JSONObject();
        JSONArray items = new JSONArray();
        if (tokenizer) {
            items.addAll(objects);
        } else {
            if (page == 1) {
                String message = this.getSearchResultsMessage(portalControllerContext, total, bundle);
                JSONObject object = new JSONObject();
                object.put((Object)"message", (Object)message);
                items.add((Object)object);
            }
            int begin = (page - 1) * 6;
            int end = Math.min(objects.size(), begin + 6);
            for (int i = begin; i < end; ++i) {
                JSONObject object = (JSONObject)objects.get(i);
                items.add((Object)object);
            }
            results.put((Object)"page", (Object)page);
            results.put((Object)"pageSize", (Object)6);
        }
        results.put((Object)"items", (Object)items);
        results.put((Object)"total", (Object)objects.size());
        return results;
    }

    protected JSONObject getSearchResult(Person person, boolean alreadyMember, boolean alreadyInvited, boolean existingRequest, Bundle bundle) {
        String extra;
        String displayName;
        JSONObject object = new JSONObject();
        object.put((Object)"id", (Object)person.getUid());
        if (StringUtils.isEmpty((String)person.getDisplayName())) {
            displayName = person.getUid();
            extra = null;
        } else {
            displayName = person.getDisplayName();
            extra = person.getUid();
            if (StringUtils.isNotBlank((String)person.getMail()) && !StringUtils.equals((String)person.getUid(), (String)person.getMail())) {
                extra = extra + " \u2013 " + person.getMail();
            }
        }
        if (alreadyMember) {
            displayName = displayName + " " + bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ALREADY_MEMBER_INDICATOR");
            object.put((Object)"disabled", (Object)true);
        } else if (alreadyInvited) {
            displayName = displayName + " " + bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ALREADY_INVITED");
            object.put((Object)"disabled", (Object)true);
        } else if (existingRequest) {
            displayName = displayName + " " + bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_EXISTING_INVITATION_REQUEST_INDICATOR");
            object.put((Object)"disabled", (Object)true);
        }
        object.put((Object)"displayName", (Object)displayName);
        object.put((Object)"extra", (Object)extra);
        object.put((Object)"avatar", (Object)person.getAvatar().getUrl());
        return object;
    }

    protected boolean enablePersonCreation() {
        return true;
    }

    protected void addPersonCreationSearchResult(List<Person> persons, List<JSONObject> objects, String filter, Bundle bundle) throws PortletException {
        Matcher matcher = this.mailPattern.matcher(filter);
        boolean exists = false;
        if (matcher.matches()) {
            for (Person person : persons) {
                if (!filter.equalsIgnoreCase(person.getMail())) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)filter);
            object.put((Object)"create", (Object)true);
            if (matcher.matches()) {
                object.put((Object)"displayName", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON"));
                object.put((Object)"extra", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON_EXTRA", new Object[]{filter}));
            } else {
                object.put((Object)"displayName", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON_INVALID"));
                object.put((Object)"extra", (Object)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATIONS_CREATE_PERSON_INVALID_EXTRA", new Object[]{filter}));
                object.put((Object)"disabled", (Object)true);
            }
            objects.add(object);
        }
    }

    protected String getSearchResultsMessage(PortalControllerContext portalControllerContext, int total, Bundle bundle) throws PortletException {
        String message = total == 0 ? bundle.getString("SELECT2_NO_RESULTS") : (total == 1 ? bundle.getString("SELECT2_ONE_RESULT") : (total > 100 ? bundle.getString("SELECT2_TOO_MANY_RESULTS", new Object[]{100}) : bundle.getString("SELECT2_MULTIPLE_RESULTS", new Object[]{total})));
        return message;
    }

    public void sortInvitations(PortalControllerContext portalControllerContext, InvitationsForm form, MembersSort sort, boolean alt) throws PortletException {
        InvitationObjectComparator comparator = (InvitationObjectComparator)this.applicationContext.getBean(InvitationObjectComparator.class, new Object[]{sort, alt});
        Collections.sort(form.getInvitations(), comparator);
        form.setSort(sort);
        form.setAlt(alt);
    }

    public void updateInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        this.repository.updateInvitations(portalControllerContext, form.getInvitations());
        int count = this.repository.getInvitationsCount(portalControllerContext, workspaceId);
        options.setInvitationsCount(count);
        this.invalidateLoadedForms();
        this.getInvitationsForm(portalControllerContext);
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void purgeInvitationsHistory(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        List invitations = form.getInvitations();
        if (CollectionUtils.isNotEmpty((Collection)invitations)) {
            for (Invitation invitation : invitations) {
                if (InvitationState.SENT.equals((Object)invitation.getState())) continue;
                invitation.setDeleted(true);
            }
            this.repository.updateInvitations(portalControllerContext, form.getInvitations());
            form.setLoaded(false);
            this.getInvitationsForm(portalControllerContext);
            String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_PURGE_SUCCESS");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        }
    }

    public void deleteInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm form, String[] identifiers) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        HashSet<String> sortedIdentifiers = new HashSet<String>(Arrays.asList(identifiers));
        ArrayList<Invitation> deletedInvitations = new ArrayList<Invitation>(sortedIdentifiers.size());
        for (Invitation invitation : form.getInvitations()) {
            if (!sortedIdentifiers.contains(invitation.getDocument().getId()) || invitation.getState() == null || !invitation.getState().isEditable()) continue;
            invitation.setDeleted(true);
            deletedInvitations.add(invitation);
        }
        this.repository.updateInvitations(portalControllerContext, deletedInvitations);
        form.getInvitations().removeAll(deletedInvitations);
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_DELETE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void validateInvitationsCreationForm(Errors errors, InvitationsCreationForm form) {
        if (CollectionUtils.isNotEmpty((Collection)form.getPendingInvitations())) {
            for (Invitation invitation : form.getPendingInvitations()) {
                Matcher matcher;
                if (!invitation.isUnknownUser() || (matcher = this.mailPattern.matcher(StringUtils.trim((String)invitation.getId()))).matches()) continue;
                Object[] errorArgs = new Object[]{invitation.getId()};
                errors.rejectValue("pendingInvitations", "Invalid", errorArgs, null);
            }
        }
    }

    public void createInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm invitationsForm, InvitationsCreationForm creationForm) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        ArrayList<String> invitationIdentifiers = new ArrayList<String>(creationForm.getPendingInvitations().size());
        for (Invitation invitation : creationForm.getPendingInvitations()) {
            if (!invitation.isUnknownUser()) continue;
            invitationIdentifiers.add(invitation.getId());
        }
        if (invitationIdentifiers.isEmpty() || creationForm.isWarning()) {
            boolean created = this.repository.createInvitations(portalControllerContext, options.getWorkspaceId(), invitationsForm.getInvitations(), creationForm);
            if (created) {
                options.setInvitationsCount(this.repository.getInvitationsCount(portalControllerContext, options.getWorkspaceId()));
                invitationsForm.setLoaded(false);
                creationForm.setLocalGroups(null);
                creationForm.setMessage(null);
                this.getInvitationsForm(portalControllerContext);
                String message = bundle.getString("MESSAGE_WORKSPACE_INVITATIONS_CREATION_SUCCESS");
                this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
            }
            creationForm.getPendingInvitations().clear();
            creationForm.setWarning(false);
        } else {
            creationForm.setWarning(true);
        }
    }

    public String getInvitationsHelp(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getHelp(portalControllerContext, "workspace-member-management.invitations.help.location");
    }

    public Element getInvitationsToolbar(PortalControllerContext portalControllerContext, List<String> indexes) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Element container = DOM4JUtils.generateDivElement(null);
        Element toolbar = DOM4JUtils.generateDivElement((String)"btn-toolbar", (AccessibilityRoles)AccessibilityRoles.TOOLBAR);
        container.add(toolbar);
        if (CollectionUtils.isNotEmpty(indexes)) {
            InvitationsForm form = this.getInvitationsForm(portalControllerContext);
            List invitations = form.getInvitations();
            ArrayList<Invitation> selectedInvitations = new ArrayList<Invitation>(indexes.size());
            for (String index : indexes) {
                Invitation invitation;
                int i = NumberUtils.toInt((String)index, (int)-1);
                if (i <= -1 || i >= invitations.size() || (invitation = (Invitation)invitations.get(i)).getDocument() == null) continue;
                selectedInvitations.add(invitation);
            }
            if (indexes.size() == selectedInvitations.size()) {
                Invitation invitation;
                boolean allEditable;
                boolean editable;
                Iterator iterator = selectedInvitations.iterator();
                for (allEditable = true; allEditable && iterator.hasNext(); allEditable &= editable) {
                    Invitation invitation2 = (Invitation)iterator.next();
                    editable = invitation2.getState() != null && invitation2.getState().isEditable();
                }
                String[] identifiers = new String[selectedInvitations.size()];
                for (int i = 0; i < selectedInvitations.size(); ++i) {
                    invitation = (Invitation)selectedInvitations.get(i);
                    identifiers[i] = invitation.getDocument().getId();
                }
                String tab = "invitations";
                if (selectedInvitations.size() == 1) {
                    invitation = (Invitation)selectedInvitations.get(0);
                    Element manage = this.getManageInvitationToolbarButton(portalControllerContext, invitation, bundle);
                    toolbar.add(manage);
                }
                Element resend = this.getResendInvitationsToolbarButton(portalControllerContext, identifiers, allEditable, bundle);
                toolbar.add(resend);
                Element changeRole = this.getChangeRoleToolbarButton(portalControllerContext, identifiers, allEditable, tab, bundle);
                toolbar.add(changeRole);
                Element addToGroup = this.getAddToGroupToolbarButton(portalControllerContext, identifiers, tab, bundle);
                toolbar.add(addToGroup);
                Element delete = this.getDeleteInvitationsToolbarButton(portalControllerContext, allEditable, bundle);
                toolbar.add(delete);
                Boolean administrator = Boolean.TRUE.equals(portalControllerContext.getRequest().getAttribute("osivia.isAdministrator"));
                if (selectedInvitations.size() == 1 && administrator.booleanValue()) {
                    Invitation invitation3 = (Invitation)selectedInvitations.get(0);
                    Element drop = this.getDropInvitationToolbarButton(portalControllerContext, (InvitationObject)invitation3, bundle, "invitations");
                    toolbar.add(drop);
                }
                if (allEditable) {
                    Element deleteConfirmationModal = this.getDeleteInvitationsConfirmationModal(portalControllerContext, selectedInvitations, identifiers, bundle);
                    container.add(deleteConfirmationModal);
                }
            }
        }
        return container;
    }

    protected Element getManageInvitationToolbarButton(PortalControllerContext portalControllerContext, Invitation invitation, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String htmlClass = "btn btn-default btn-sm";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_EDIT");
        String icon = "glyphicons glyphicons-pencil";
        if (invitation.getState() != null && invitation.getState().isEditable() && mimeResponse != null) {
            PortletURL renderUrl = mimeResponse.createRenderURL();
            renderUrl.setParameter("view", "invitation-edition");
            renderUrl.setParameter("invitationPath", invitation.getDocument().getPath());
            url = renderUrl.toString();
        } else {
            url = null;
        }
        if (StringUtils.isEmpty(url)) {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        return DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
    }

    protected Element getDropInvitationToolbarButton(PortalControllerContext portalControllerContext, InvitationObject invitation, Bundle bundle, String tab) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String htmlClass = "btn btn-danger btn-sm";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_DROP");
        String icon = "glyphicons glyphicons-remove";
        if (invitation.getState() != null && invitation.getState().isEditable() && mimeResponse != null) {
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "drop");
            actionUrl.setParameter("invitationPath", invitation.getDocument().getPath());
            actionUrl.setParameter("view", "tab=invitations");
            actionUrl.setParameter("fromtab", tab);
            url = actionUrl.toString();
        } else {
            url = null;
        }
        if (StringUtils.isEmpty(url)) {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        return DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
    }

    protected Element getResendInvitationsToolbarButton(PortalControllerContext portalControllerContext, String[] identifiers, boolean allEditable, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String htmlClass = "btn btn-default btn-sm";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_EDITION_RESEND");
        String icon = "glyphicons glyphicons-message-out";
        if (allEditable && mimeResponse != null) {
            PortletURL renderUrl = mimeResponse.createRenderURL();
            renderUrl.setParameter("tab", "invitations");
            renderUrl.setParameter("view", "resend");
            renderUrl.setParameter("identifiers", identifiers);
            url = renderUrl.toString();
        } else {
            url = null;
        }
        if (StringUtils.isEmpty(url)) {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        return DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
    }

    protected Element getDeleteInvitationsToolbarButton(PortalControllerContext portalControllerContext, boolean allEditable, Bundle bundle) {
        String url;
        PortletResponse response = portalControllerContext.getResponse();
        String htmlClass = "btn btn-default btn-sm no-ajax-link";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_DELETE");
        String icon = "glyphicons glyphicons-bin";
        if (allEditable) {
            url = "#" + response.getNamespace() + "-delete";
        } else {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        Element button = DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
        if (allEditable) {
            DOM4JUtils.addDataAttribute((Element)button, (String)"toggle", (String)"modal");
        }
        return button;
    }

    protected Element getDeleteInvitationsConfirmationModal(PortalControllerContext portalControllerContext, List<Invitation> selectedInvitations, String[] identifiers, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String modalId = portletResponse.getNamespace() + "-delete";
        String title = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_DELETE_CONFIRMATION_TITLE");
        Element content = DOM4JUtils.generateDivElement(null);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_DELETE_CONFIRMATION_MESSAGE"));
        content.add(message);
        Element ul = this.getSelectionModalBodyContent(selectedInvitations, bundle);
        content.add(ul);
        if (mimeResponse == null) {
            url = "#";
        } else {
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "delete");
            actionUrl.setParameter("tab", "invitations");
            actionUrl.setParameter("identifiers", identifiers);
            url = actionUrl.toString();
        }
        Element confirm = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-warning no-ajax-link", (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_INVITATION_DELETE"), null);
        return this.getConfirmationModal(portalControllerContext, modalId, title, content, confirm, bundle);
    }

    public void acceptInvitationRequests(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationRequestsForm form, String[] identifiers) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        HashSet<String> sortedIdentifiers = new HashSet<String>(Arrays.asList(identifiers));
        List requests = form.getRequests();
        for (InvitationRequest request : requests) {
            if (request.getDocument() == null || !sortedIdentifiers.contains(request.getDocument().getId()) || request.getState() == null || !request.getState().isEditable()) continue;
            request.setAccepted(true);
        }
        this.repository.updateInvitationRequests(portalControllerContext, workspaceId, requests);
        this.invalidateLoadedForms();
        List updatedRequests = this.getInvitationRequestsForm(portalControllerContext).getRequests();
        form.setRequests(updatedRequests);
        String message = bundle.getString("MESSAGE_WORKSPACE_ACCEPT_REQUEST_INVITATIONS_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void declineInvitationRequests(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationRequestsForm form, String[] identifiers) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        HashSet<String> sortedIdentifiers = new HashSet<String>(Arrays.asList(identifiers));
        List requests = form.getRequests();
        for (InvitationRequest request : requests) {
            if (request.getDocument() == null || !sortedIdentifiers.contains(request.getDocument().getId()) || request.getState() == null || !request.getState().isEditable()) continue;
            request.setDeleted(true);
        }
        this.repository.updateInvitationRequests(portalControllerContext, workspaceId, requests);
        this.invalidateLoadedForms();
        List updatedRequests = this.getInvitationRequestsForm(portalControllerContext).getRequests();
        form.setRequests(updatedRequests);
        String message = bundle.getString("MESSAGE_WORKSPACE_DECLINE_REQUEST_INVITATIONS_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public InvitationRequestsForm getInvitationRequestsForm(PortalControllerContext portalControllerContext) throws PortletException {
        InvitationRequestsForm form = (InvitationRequestsForm)this.applicationContext.getBean(InvitationRequestsForm.class);
        if (!form.isLoaded()) {
            String workspaceId = this.repository.getCurrentWorkspaceId(portalControllerContext);
            Set memberIdentifiers = this.getMembersForm(portalControllerContext).getIdentifiers();
            List requests = this.repository.getInvitationRequests(portalControllerContext, workspaceId, memberIdentifiers);
            form.setRequests(requests);
            HashSet<String> requestIdentifiers = new HashSet<String>();
            for (InvitationRequest request : requests) {
                if (!InvitationState.SENT.equals((Object)request.getState())) continue;
                requestIdentifiers.add(request.getId());
            }
            form.setIdentifiers(requestIdentifiers);
            this.sortInvitationRequests(portalControllerContext, form, MembersSort.DATE, true);
            form.setLoaded(true);
        }
        return form;
    }

    public Element getInvitationRequestsToolbar(PortalControllerContext portalControllerContext, List<String> indexes) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Element container = DOM4JUtils.generateDivElement(null);
        Element toolbar = DOM4JUtils.generateDivElement((String)"btn-toolbar", (AccessibilityRoles)AccessibilityRoles.TOOLBAR);
        container.add(toolbar);
        if (CollectionUtils.isNotEmpty(indexes)) {
            InvitationRequestsForm form = this.getInvitationRequestsForm(portalControllerContext);
            List requests = form.getRequests();
            ArrayList<InvitationRequest> selectedRequests = new ArrayList<InvitationRequest>(indexes.size());
            for (String index : indexes) {
                InvitationRequest request;
                int i = NumberUtils.toInt((String)index, (int)-1);
                if (i <= -1 || i >= requests.size() || (request = (InvitationRequest)requests.get(i)).getDocument() == null) continue;
                selectedRequests.add(request);
            }
            if (indexes.size() == selectedRequests.size()) {
                boolean allEditable;
                boolean editable;
                Iterator iterator = selectedRequests.iterator();
                for (allEditable = true; allEditable && iterator.hasNext(); allEditable &= editable) {
                    InvitationRequest request = (InvitationRequest)iterator.next();
                    editable = request.getState() != null && request.getState().isEditable();
                }
                String[] identifiers = new String[selectedRequests.size()];
                for (int i = 0; i < selectedRequests.size(); ++i) {
                    InvitationRequest request = (InvitationRequest)selectedRequests.get(i);
                    identifiers[i] = request.getDocument().getId();
                }
                Element changeRole = this.getChangeRoleToolbarButton(portalControllerContext, identifiers, allEditable, "requests", bundle);
                toolbar.add(changeRole);
                Element accept = this.getAcceptInvitationRequestToolbarButton(portalControllerContext, allEditable, bundle);
                toolbar.add(accept);
                Element decline = this.getDeclineInvitationRequestToolbarButton(portalControllerContext, allEditable, bundle);
                toolbar.add(decline);
                Boolean administrator = Boolean.TRUE.equals(portalControllerContext.getRequest().getAttribute("osivia.isAdministrator"));
                if (selectedRequests.size() == 1 && administrator.booleanValue()) {
                    InvitationRequest request = (InvitationRequest)selectedRequests.get(0);
                    Element drop = this.getDropInvitationToolbarButton(portalControllerContext, (InvitationObject)request, bundle, "requests");
                    toolbar.add(drop);
                }
                if (allEditable) {
                    Element acceptConfirmationModal = this.getAcceptInvitationRequestConfirmationModal(portalControllerContext, selectedRequests, identifiers, bundle);
                    container.add(acceptConfirmationModal);
                    Element declineConfirmationModal = this.getDeclineInvitationRequestConfirmationModal(portalControllerContext, selectedRequests, identifiers, bundle);
                    container.add(declineConfirmationModal);
                }
            }
        }
        return container;
    }

    protected Element getAcceptInvitationRequestToolbarButton(PortalControllerContext portalControllerContext, boolean allEditable, Bundle bundle) {
        String url;
        PortletResponse response = portalControllerContext.getResponse();
        String htmlClass = "btn btn-success btn-sm no-ajax-link";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ACCEPT_INVITATION_REQUEST");
        String icon = "glyphicons glyphicons-ok-sign";
        if (allEditable) {
            url = "#" + response.getNamespace() + "-accept";
        } else {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        Element button = DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
        if (allEditable) {
            DOM4JUtils.addDataAttribute((Element)button, (String)"toggle", (String)"modal");
        }
        return button;
    }

    protected Element getDeclineInvitationRequestToolbarButton(PortalControllerContext portalControllerContext, boolean allEditable, Bundle bundle) {
        String url;
        PortletResponse response = portalControllerContext.getResponse();
        String htmlClass = "btn btn-danger btn-sm no-ajax-link";
        String text = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_DECLINE_INVITATION_REQUEST");
        String icon = "glyphicons glyphicons-remove-sign";
        if (allEditable) {
            url = "#" + response.getNamespace() + "-decline";
        } else {
            url = "#";
            htmlClass = htmlClass + " disabled";
        }
        Element button = DOM4JUtils.generateLinkElement((String)url, null, null, (String)htmlClass, (String)text, (String)icon);
        if (allEditable) {
            DOM4JUtils.addDataAttribute((Element)button, (String)"toggle", (String)"modal");
        }
        return button;
    }

    protected Element getAcceptInvitationRequestConfirmationModal(PortalControllerContext portalControllerContext, List<InvitationRequest> selectedRequests, String[] identifiers, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String modalId = portletResponse.getNamespace() + "-accept";
        String title = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ACCEPT_INVITATION_REQUEST_CONFIRMATION_MODAL_TITLE");
        Element content = DOM4JUtils.generateDivElement(null);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ACCEPT_INVITATION_REQUEST_CONFIRMATION_MODAL_MESSAGE"));
        content.add(message);
        Element ul = this.getSelectionModalBodyContent(selectedRequests, bundle);
        content.add(ul);
        if (mimeResponse == null) {
            url = "#";
        } else {
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "accept");
            actionUrl.setParameter("tab", "requests");
            actionUrl.setParameter("identifiers", identifiers);
            url = actionUrl.toString();
        }
        Element confirm = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-success no-ajax-link", (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_ACCEPT_INVITATION_REQUEST"), null);
        return this.getConfirmationModal(portalControllerContext, modalId, title, content, confirm, bundle);
    }

    protected Element getDeclineInvitationRequestConfirmationModal(PortalControllerContext portalControllerContext, List<InvitationRequest> selectedRequests, String[] identifiers, Bundle bundle) {
        String url;
        PortletResponse portletResponse = portalControllerContext.getResponse();
        MimeResponse mimeResponse = portletResponse instanceof MimeResponse ? (MimeResponse)portletResponse : null;
        String modalId = portletResponse.getNamespace() + "-decline";
        String title = bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_DECLINE_INVITATION_REQUEST_CONFIRMATION_MODAL_TITLE");
        Element content = DOM4JUtils.generateDivElement(null);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_DECLINE_INVITATION_REQUEST_CONFIRMATION_MODAL_MESSAGE"));
        content.add(message);
        Element ul = this.getSelectionModalBodyContent(selectedRequests, bundle);
        content.add(ul);
        if (mimeResponse == null) {
            url = "#";
        } else {
            PortletURL actionUrl = mimeResponse.createActionURL();
            actionUrl.setParameter("javax.portlet.action", "decline");
            actionUrl.setParameter("tab", "requests");
            actionUrl.setParameter("identifiers", identifiers);
            url = actionUrl.toString();
        }
        Element confirm = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"btn btn-danger no-ajax-link", (String)bundle.getString("WORKSPACE_MEMBER_MANAGEMENT_DECLINE_INVITATION_REQUEST"), null);
        return this.getConfirmationModal(portalControllerContext, modalId, title, content, confirm, bundle);
    }

    public void sortInvitationRequests(PortalControllerContext portalControllerContext, InvitationRequestsForm form, MembersSort sort, boolean alt) throws PortletException {
        InvitationObjectComparator comparator = (InvitationObjectComparator)this.applicationContext.getBean(InvitationObjectComparator.class, new Object[]{sort, alt});
        Collections.sort(form.getRequests(), comparator);
        form.setSort(sort);
        form.setAlt(alt);
    }

    public String getInvitationRequestsHelp(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getHelp(portalControllerContext, "workspace-member-management.requests.help.location");
    }

    public InvitationEditionForm getInvitationEditionForm(PortalControllerContext portalControllerContext, String path) throws PortletException {
        return this.repository.getInvitationEditionForm(portalControllerContext, path);
    }

    public void resendInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        Date resendingDate = new Date();
        this.repository.resendInvitation(portalControllerContext, form, resendingDate);
        String message = form.getMessage();
        form.setMessage(null);
        form.getInvitation().setMessage(message);
        form.getInvitation().setResendingDate(resendingDate);
        this.invalidateLoadedForms();
    }

    public void updateInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Invitation invitation = form.getInvitation();
        invitation.setEdited(true);
        ArrayList<Invitation> invitations = new ArrayList<Invitation>(1);
        invitations.add(invitation);
        this.repository.updateInvitations(portalControllerContext, invitations);
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void deleteInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Invitation invitation = form.getInvitation();
        invitation.setDeleted(true);
        ArrayList<Invitation> invitations = new ArrayList<Invitation>(1);
        invitations.add(invitation);
        this.repository.updateInvitations(portalControllerContext, invitations);
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_DELETE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public <M extends MemberObject, F extends AbstractChangeRoleForm<M>> F getChangeRoleForm(PortalControllerContext portalControllerContext, String[] identifiers, Class<M> memberType, Class<F> formType) throws PortletException {
        List selection = this.getSelection(portalControllerContext, identifiers, memberType);
        AbstractChangeRoleForm form = (AbstractChangeRoleForm)this.applicationContext.getBean(formType);
        form.setMembers(selection);
        this.sortMembers(portalControllerContext, (AbstractMembersForm)form, MembersSort.MEMBER_DISPLAY_NAME, false);
        return (F)form;
    }

    protected <M extends MemberObject> List<M> getSelection(PortalControllerContext portalControllerContext, String[] identifiers, Class<M> memberType) throws PortletException {
        ArrayList<MemberObject> selection;
        Object parentForm = Member.class.isAssignableFrom(memberType) ? this.getMembersForm(portalControllerContext) : (Invitation.class.isAssignableFrom(memberType) ? this.getInvitationsForm(portalControllerContext) : (InvitationRequest.class.isAssignableFrom(memberType) ? this.getInvitationRequestsForm(portalControllerContext) : null));
        List members = parentForm == null ? null : parentForm.getMembers();
        if (ArrayUtils.isEmpty((Object[])identifiers) || CollectionUtils.isEmpty((Collection)members)) {
            selection = null;
        } else {
            HashMap<String, MemberObject> sortedMembers = new HashMap<String, MemberObject>(members.size());
            for (MemberObject member : members) {
                InvitationObject invitation;
                Object id = member instanceof InvitationObject ? ((invitation = (InvitationObject)member).getDocument() == null ? null : invitation.getDocument().getId()) : member.getId();
                if (!StringUtils.isNotEmpty((String)id)) continue;
                sortedMembers.put((String)id, member);
            }
            selection = new ArrayList<MemberObject>(identifiers.length);
            for (String identifier : identifiers) {
                MemberObject member;
                try {
                    member = (MemberObject)memberType.cast(sortedMembers.get(identifier));
                }
                catch (ClassCastException e) {
                    member = null;
                }
                if (member == null) continue;
                selection.add(member);
            }
        }
        return selection;
    }

    public <M extends MemberObject, F extends AbstractChangeRoleForm<M>> void updateRole(PortalControllerContext portalControllerContext, MemberManagementOptions options, F form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        WorkspaceRole role = form.getRole();
        String workspaceId = options.getWorkspaceId();
        List selection = form.getMembers();
        if (form instanceof ChangeMembersRoleForm) {
            for (MemberObject object : selection) {
                Member member;
                if (!(object instanceof Member) || !(member = (Member)object).isEditable()) continue;
                member.setEdited(true);
                member.setRole(role);
                this.repository.updateMember(portalControllerContext, workspaceId, member);
            }
        } else if (form instanceof ChangeInvitationsRoleForm) {
            ArrayList<Invitation> invitations = new ArrayList<Invitation>(selection.size());
            for (MemberObject object : selection) {
                Invitation invitation;
                if (!(object instanceof Invitation) || (invitation = (Invitation)object).getState() == null || !invitation.getState().isEditable()) continue;
                invitation.setEdited(true);
                invitation.setRole(role);
                invitations.add(invitation);
            }
            this.repository.updateInvitations(portalControllerContext, invitations);
        } else if (form instanceof ChangeInvitationRequestsRoleForm) {
            ArrayList<InvitationRequest> requests = new ArrayList<InvitationRequest>(selection.size());
            for (MemberObject object : selection) {
                InvitationRequest request;
                if (!(object instanceof InvitationRequest) || (request = (InvitationRequest)object).getState() == null || !request.getState().isEditable()) continue;
                request.setEdited(true);
                request.setRole(role);
                requests.add(request);
            }
            this.repository.updateInvitationRequests(portalControllerContext, workspaceId, requests);
        }
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_ROLE_UPDATE_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public <M extends MemberObject, F extends AbstractAddToGroupForm<M>> F getAddToGroupForm(PortalControllerContext portalControllerContext, String[] identifiers, Class<M> memberType, Class<F> formType) throws PortletException {
        List selection = this.getSelection(portalControllerContext, identifiers, memberType);
        AbstractAddToGroupForm form = (AbstractAddToGroupForm)this.applicationContext.getBean(formType);
        form.setMembers(selection);
        this.sortMembers(portalControllerContext, (AbstractMembersForm)form, MembersSort.MEMBER_DISPLAY_NAME, false);
        return (F)form;
    }

    public <M extends MemberObject, F extends AbstractAddToGroupForm<M>> void addToGroup(PortalControllerContext portalControllerContext, MemberManagementOptions options, F form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String workspaceId = options.getWorkspaceId();
        List selection = form.getMembers();
        if (form instanceof AddMembersToGroupForm) {
            ArrayList<MemberObject> members = new ArrayList<MemberObject>(form.getMembers().size());
            for (MemberObject member : form.getMembers()) {
                members.add(member);
            }
            for (CollabProfile localGroup : form.getLocalGroups()) {
                this.repository.addToGroup(portalControllerContext, workspaceId, members, localGroup);
            }
        } else if (form instanceof AddInvitationsToGroupForm) {
            ArrayList<Invitation> invitations = new ArrayList<Invitation>(selection.size());
            for (MemberObject object : selection) {
                Invitation invitation;
                if (!(object instanceof Invitation) || (invitation = (Invitation)object).getState() == null || !invitation.getState().isEditable()) continue;
                HashSet updatedLocalGroups = new HashSet();
                if (CollectionUtils.isNotEmpty((Collection)invitation.getLocalGroups())) {
                    updatedLocalGroups.addAll(invitation.getLocalGroups());
                }
                if (CollectionUtils.isNotEmpty((Collection)form.getLocalGroups())) {
                    updatedLocalGroups.addAll(form.getLocalGroups());
                }
                invitation.setEdited(true);
                invitation.setLocalGroups(new ArrayList(updatedLocalGroups));
                invitations.add(invitation);
            }
            this.repository.updateInvitations(portalControllerContext, invitations);
        }
        this.invalidateLoadedForms();
        String message = bundle.getString("MESSAGE_WORKSPACE_ADD_TO_GROUP_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public ResendInvitationsForm getResendInvitationsForm(PortalControllerContext portalControllerContext, String[] identifiers) throws PortletException {
        List selection = this.getSelection(portalControllerContext, identifiers, Invitation.class);
        ResendInvitationsForm form = (ResendInvitationsForm)this.applicationContext.getBean(ResendInvitationsForm.class);
        form.setMembers(selection);
        this.sortMembers(portalControllerContext, (AbstractMembersForm)form, MembersSort.MEMBER_DISPLAY_NAME, false);
        return form;
    }

    public void resendInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, ResendInvitationsForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        Date date = new Date();
        boolean status = this.repository.resendInvitations(portalControllerContext, form.getMembers(), form.getMessage(), date);
        this.invalidateLoadedForms();
        if (status) {
            String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_RESENDING_SUCCESS");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
        } else {
            String message = bundle.getString("MESSAGE_WORKSPACE_INVITATION_RESENDING_ERROR");
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
        }
    }

    protected void invalidateLoadedForms() {
        MembersForm membersForm = (MembersForm)this.applicationContext.getBean(MembersForm.class);
        membersForm.setLoaded(false);
        InvitationsForm invitationsForm = (InvitationsForm)this.applicationContext.getBean(InvitationsForm.class);
        invitationsForm.setLoaded(false);
        InvitationRequestsForm requestsForm = (InvitationRequestsForm)this.applicationContext.getBean(InvitationRequestsForm.class);
        requestsForm.setLoaded(false);
        ImportForm importForm = (ImportForm)this.applicationContext.getBean(ImportForm.class);
        importForm.setLoaded(false);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        ApplicationContextProvider.setApplicationContext((ApplicationContext)applicationContext);
    }

    public void dropInvitation(PortalControllerContext portalControllerContext, String invitationPath) {
        this.repository.dropInvitation(portalControllerContext, invitationPath);
        this.invalidateLoadedForms();
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String message = bundle.getString("MESSAGE_WORKSPACE_DROP_WF_SUCCESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public ImportForm getImportForm(PortalControllerContext portalControllerContext) {
        ImportForm form = (ImportForm)this.applicationContext.getBean(ImportForm.class);
        if (!form.isLoaded()) {
            form.setRole(WorkspaceRole.READER);
            Person person = (Person)portalControllerContext.getRequest().getAttribute("osivia.directory.v2.loggedPerson");
            form.setInitiator(person.getUid());
            form.setLocalGroups(null);
            form.setMessage(null);
            form.setUpload(null);
            form.setLoaded(true);
        }
        return form;
    }

    public void prepareImportInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, ImportForm form) throws ParseException, PortalException {
        String batchId = "importmembers_" + options.getWorkspaceId() + "_" + new Date().getTime();
        MultipartFile upload = form.getUpload();
        ImportObject dto = new ImportObject();
        try {
            File temporaryFile = File.createTempFile(batchId, ".tmp");
            upload.transferTo(temporaryFile);
            dto.setTemporaryFile(temporaryFile);
            dto.setInitiator(form.getInitiator());
            dto.setLocalGroups(form.getLocalGroups());
            dto.setMessage(form.getMessage());
            dto.setRole(form.getRole());
            dto.setWorkspaceId(options.getWorkspaceId());
            Document currentWorkspace = this.repository.getCurrentWorkspace(portalControllerContext);
            dto.setCurrentWorkspace(currentWorkspace);
        }
        catch (IOException e) {
            throw new PortalException((Exception)e);
        }
        ImportInvitationsBatch batch = new ImportInvitationsBatch(portalControllerContext.getPortletCtx(), dto);
        this.batchService.addBatch((AbstractBatch)batch);
        this.invalidateLoadedForms();
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        String message = bundle.getString("MESSAGE_IMPORT_IN_PROGRESS");
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.INFO);
    }
}

