/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.plugin.portlet;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.portlet.PrivilegedPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.plugin.portlet.RequestsListTemplateModule;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.osivia.services.workspace.util.ApplicationContextProvider;
import org.springframework.context.ApplicationContext;

public class RequestsListTemplateModule
extends PrivilegedPortletModule {
    private MemberManagementRepository repository;

    public RequestsListTemplateModule(PortletContext portletContext) {
        super(portletContext);
    }

    public int getAuthType() {
        return NuxeoCommandContext.AUTH_TYPE_SUPERUSER;
    }

    public String getFilter(PortalControllerContext portalControllerContext) {
        String filter;
        PortletRequest request = portalControllerContext.getRequest();
        String user = request.getRemoteUser();
        if (user == null) {
            filter = "1 = 0";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("ecm:primaryType = 'Workspace' ");
            builder.append("AND ttcs:spaceMembers/*/login <> '").append(user).append("' ");
            builder.append("AND ttcs:visibility IN (");
            WorkspaceType[] workspaceTypes = new WorkspaceType[]{WorkspaceType.PUBLIC, WorkspaceType.PUBLIC_INVITATION, WorkspaceType.PRIVATE};
            boolean first = true;
            for (WorkspaceType workspaceType : workspaceTypes) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("'");
                builder.append(workspaceType.getId());
                builder.append("'");
            }
            builder.append(")");
            filter = builder.toString();
        }
        return filter;
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, (PortletRequest)request, (PortletResponse)response);
        String user = request.getRemoteUser();
        Map pendingStatus = this.getPendingStatus(portalControllerContext, user);
        List documents = (List)request.getAttribute("documents");
        for (Object object : documents) {
            DocumentDTO documentDto = (DocumentDTO)object;
            DocumentType documentType = documentDto.getType();
            if (documentType == null || !StringUtils.equals((String)"Workspace", (String)documentType.getName())) continue;
            Document workspace = documentDto.getDocument();
            Map properties = documentDto.getProperties();
            String visibility = workspace.getString("ttcs:visibility");
            if (StringUtils.isNotEmpty((String)visibility)) {
                WorkspaceType type = WorkspaceType.valueOf((String)visibility);
                properties.put("workspaceType", type);
            }
            MemberStatus status = this.getMemberStatus(workspace, user, pendingStatus);
            properties.put("memberStatus", status);
        }
    }

    protected Map<String, MemberStatus> getPendingStatus(PortalControllerContext portalControllerContext, String user) throws PortletException {
        HashMap<String, MemberStatus> pendingStatus;
        if (StringUtils.isEmpty((String)user)) {
            pendingStatus = null;
        } else {
            MemberManagementRepository repository = this.getRepository();
            List pendingInvitations = repository.getPendingInvitations(portalControllerContext, user);
            pendingStatus = new HashMap<String, MemberStatus>(pendingInvitations.size());
            for (Document pendingInvitation : pendingInvitations) {
                String workspaceId;
                PropertyMap variables;
                String modelWebId = pendingInvitation.getString("pi:procedureModelWebId");
                String modelId = StringUtils.removeStart((String)modelWebId, (String)"procedure_");
                Object status = "invitation".equals(modelId) ? MemberStatus.INVITATION_PENDING : ("invitation-request".equals(modelId) ? MemberStatus.REQUEST_PENDING : null);
                if (status == null || (variables = pendingInvitation.getProperties().getMap("pi:globalVariablesValues")) == null || !StringUtils.isNotEmpty((String)(workspaceId = variables.getString("workspaceId")))) continue;
                pendingStatus.put(workspaceId, (MemberStatus)status);
            }
        }
        return pendingStatus;
    }

    protected MemberStatus getMemberStatus(Document workspace, String user, Map<String, MemberStatus> pendingStatus) {
        MemberStatus status;
        if (StringUtils.isEmpty((String)user)) {
            status = null;
        } else {
            PropertyList members;
            String workspaceId = workspace.getString("webc:url");
            status = pendingStatus.get(workspaceId);
            if (status == null && (members = workspace.getProperties().getList("ttcs:spaceMembers")) != null && !members.isEmpty()) {
                boolean member = false;
                for (int i = 0; !member && i < members.size(); ++i) {
                    PropertyMap map = members.getMap(i);
                    member = StringUtils.equals((String)user, (String)map.getString("login"));
                }
                if (member) {
                    status = MemberStatus.MEMBER;
                }
            }
        }
        return status;
    }

    protected void processAction(ActionRequest request, ActionResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, (PortletRequest)request, (PortletResponse)response);
        MemberManagementRepository repository = this.getRepository();
        String user = request.getRemoteUser();
        String action = request.getParameter("javax.portlet.action");
        if (StringUtils.isNotEmpty((String)user) && "createRequest".equals(action)) {
            String workspaceId = request.getParameter("id");
            String userMessage = request.getParameter("userMessage");
            if (StringUtils.isNotEmpty((String)workspaceId)) {
                repository.createInvitationRequest(portalControllerContext, workspaceId, user, userMessage);
            }
        }
    }

    private MemberManagementRepository getRepository() {
        if (this.repository == null) {
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            this.repository = (MemberManagementRepository)applicationContext.getBean(MemberManagementRepository.class);
        }
        return this.repository;
    }
}

