/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.plugin.configuration;

import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

@Configuration
@ComponentScan(basePackages={"fr.gouv.education.foad.plugin"})
public class CustomizedMemberManagementPluginConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("customized-plugin");
        return messageSource;
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader(), this.applicationContext);
    }

    @Bean
    public PersonService getPersonService() {
        return (PersonService)DirServiceFactory.getService(PersonService.class);
    }

    @Bean
    public GroupService getGroupService() {
        return (GroupService)DirServiceFactory.getService(GroupService.class);
    }
}

