/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import java.io.IOException;
import java.util.Arrays;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.services.workspace.portlet.model.AbstractMembersForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MembersForm;
import org.osivia.services.workspace.portlet.model.MembersSort;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class MemberManagementController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;
    @Autowired
    protected IBundleFactory bundleFactory;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        request.setAttribute("tab", (Object)"members");
        return "members/view";
    }

    @ExceptionHandler(value={PortletException.class})
    public String handlePortletException(PortletRequest request, PortletResponse response, PortletException exception) {
        request.setAttribute("exception", (Object)exception);
        return "error";
    }

    @ActionMapping(value="sort")
    public void sort(ActionRequest request, ActionResponse response, @RequestParam(value="sortId") String sortId, @RequestParam(value="alt") String alt, @ModelAttribute(value="members") MembersForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.sortMembers(portalControllerContext, (AbstractMembersForm)form, MembersSort.fromId((String)sortId), BooleanUtils.toBoolean((String)alt));
        response.setRenderParameter("tab", "members");
    }

    @ActionMapping(value="remove")
    public void remove(ActionRequest request, ActionResponse response, @RequestParam(value="identifiers") String[] identifiers, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="members") MembersForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.removeMembers(portalControllerContext, options, form, identifiers);
        response.setRenderParameter("tab", "members");
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ModelAttribute(value="members")
    public MembersForm getMembersForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getMembersForm(portalControllerContext);
    }

    @ModelAttribute(value="help")
    public String getHelp(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getMembersHelp(portalControllerContext);
    }

    @ResourceMapping(value="members-toolbar")
    public void getToolbar(ResourceRequest request, ResourceResponse response, @RequestParam(name="indexes", required=false) String indexes) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        Element toolbar = this.service.getMembersToolbar(portalControllerContext, Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)indexes), (String)",")));
        response.setContentType("text/html");
        HTMLWriter htmlWriter = new HTMLWriter(response.getPortletOutputStream());
        htmlWriter.write(toolbar);
        htmlWriter.close();
    }

    @ResourceMapping(value="export-members-csv")
    public void exportCsv(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="members") MembersForm members, @ModelAttribute(value="options") MemberManagementOptions options) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        response.setContentType("text/csv");
        response.setProperty("Content-disposition", "attachment; filename=\"members_" + options.getWorkspaceId() + ".csv\"");
        this.service.exportMembersCsv(portalControllerContext, members, response.getPortletOutputStream());
    }

    @ActionMapping(value="drop")
    public void drop(ActionRequest request, ActionResponse response, @RequestParam(value="invitationPath") String invitationPath, @RequestParam(value="fromtab") String fromtab) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.dropInvitation(portalControllerContext, invitationPath);
        response.setRenderParameter("tab", fromtab);
    }
}

