/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.portlet.service;

import fr.gouv.education.foad.portlet.service.CustomizedMemberManagementService;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.workspace.portlet.model.AbstractChangeRoleForm;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.model.InvitationEditionForm;
import org.osivia.services.workspace.portlet.model.InvitationsCreationForm;
import org.osivia.services.workspace.portlet.model.InvitationsForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MemberObject;
import org.osivia.services.workspace.portlet.service.MemberManagementServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
@Primary
public class CustomizedMemberManagementServiceImpl
extends MemberManagementServiceImpl
implements CustomizedMemberManagementService {
    private static final String TRIBU_LOCAL = "@tribu.local";
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;

    public void updateInvitation(PortalControllerContext portalControllerContext, InvitationEditionForm form) throws PortletException {
        boolean localAccountsOwner;
        ArrayList<String> identifiers = new ArrayList<String>();
        if (form.getInvitation().getRole().equals((Object)WorkspaceRole.OWNER)) {
            identifiers.add(form.getInvitation().getId());
        }
        if (!(localAccountsOwner = this.checkLocalAccounts(portalControllerContext, identifiers))) {
            super.updateInvitation(portalControllerContext, form);
        } else {
            this.invalidateLoadedForms();
        }
    }

    public void createInvitations(PortalControllerContext portalControllerContext, MemberManagementOptions options, InvitationsForm invitationsForm, InvitationsCreationForm creationForm) throws PortletException {
        boolean localAccountsOwner;
        ArrayList<String> identifiers = new ArrayList<String>();
        if (creationForm.getRole().equals((Object)WorkspaceRole.OWNER)) {
            for (Invitation invit : creationForm.getPendingInvitations()) {
                identifiers.add(invit.getId());
            }
        }
        if (!(localAccountsOwner = this.checkLocalAccounts(portalControllerContext, identifiers))) {
            super.createInvitations(portalControllerContext, options, invitationsForm, creationForm);
        }
    }

    private boolean checkLocalAccounts(PortalControllerContext portalControllerContext, List<String> identifiers) {
        boolean localAccounsAreOwner = false;
        String localAccountsIds = "";
        for (String identifier : identifiers) {
            if (!StringUtils.endsWith((String)identifier, (String)TRIBU_LOCAL)) continue;
            localAccounsAreOwner = true;
            if (StringUtils.isNotBlank((String)localAccountsIds)) {
                localAccountsIds = localAccountsIds + ", ";
            }
            localAccountsIds = localAccountsIds + identifier;
        }
        if (localAccounsAreOwner) {
            Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
            String message = bundle.getString("MESSAGE_WORKSPACE_MEMBERS_UPDATE_ERROR_LOCALACCOUNTS", new Object[]{localAccountsIds});
            this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
        }
        return localAccounsAreOwner;
    }

    public void validateChangeRoleForm(AbstractChangeRoleForm<?> form, Errors errors) {
        if (WorkspaceRole.OWNER.equals((Object)form.getRole())) {
            for (MemberObject member : form.getMembers()) {
                if (!StringUtils.endsWith((String)member.getId(), (String)TRIBU_LOCAL)) continue;
                errors.rejectValue("role", "LocalAccountCannotBeOwner", new Object[]{member.getDisplayName()}, null);
            }
        }
    }
}

