/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.batch;

import com.sun.mail.smtp.SMTPTransport;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.batch.NuxeoBatch;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.services.workspace.batch.ImportObject;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.repository.GetInvitationsCommand;
import org.osivia.services.workspace.portlet.repository.SetProcedureInstanceAcl;

public class ImportInvitationsBatch
extends NuxeoBatch {
    private static final int MAX_RECORDS = 100;
    private static final Log logger = LogFactory.getLog((String)"batch");
    private ImportObject dto;
    private static PortletContext portletCtx;
    private static final String MAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private final Pattern mailPattern;
    private PersonUpdateService personService;
    private WorkspaceService workspaceService;
    private List<String> invitations;
    private List<String> requests;
    private CSVPrinter rejectsPrinter;
    private File rejects;

    public boolean isRunningOnMasterOnly() {
        return false;
    }

    public ImportInvitationsBatch(PortletContext portletCtx, ImportObject dto) {
        super(dto.getTemporaryFile().getName());
        ImportInvitationsBatch.portletCtx = portletCtx;
        this.dto = dto;
        this.mailPattern = Pattern.compile(MAIL_REGEX);
        this.personService = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);
        this.workspaceService = (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);
    }

    protected PortletContext getPortletContext() {
        return portletCtx;
    }

    public String getJobScheduling() {
        return null;
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        this.populateInvitations(false);
        this.populateInvitations(true);
        try {
            CSVParser parser = CSVParser.parse((File)this.dto.getTemporaryFile(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
            int count = 1;
            int countreject = 0;
            int countinvitation = 0;
            int countalreadymember = 0;
            int countwf = 0;
            boolean hasRejects = false;
            for (CSVRecord record : parser) {
                if (count >= 100) break;
                ArrayList<String> invitationsValidated = new ArrayList<String>();
                String uid = record.get(0);
                if (invitationsValidated.contains(uid)) {
                    logger.debug((Object)(this.getBatchId() + " / " + count + "/" + uid + " : doublon"));
                    this.rejectsPrinter = this.getRejectPrinter();
                    this.rejectsPrinter.printRecord(new Object[]{uid, "Doublon "});
                    ++countreject;
                    hasRejects = true;
                }
                if (StringUtils.isNotBlank((String)uid)) {
                    uid = StringUtils.lowerCase((String)uid);
                    Matcher matcher = this.mailPattern.matcher(uid = uid.trim());
                    if (!matcher.matches()) {
                        logger.debug((Object)(this.getBatchId() + " / " + count + "/" + uid + " : email invalide"));
                        this.rejectsPrinter = this.getRejectPrinter();
                        this.rejectsPrinter.printRecord(new Object[]{uid, "Entr\u00e9e invalide / non autoris\u00e9e "});
                        ++countreject;
                        hasRejects = true;
                    } else if (!this.invitations.contains(uid) && !this.requests.contains(uid)) {
                        ArrayList<String> localGroupIds;
                        logger.debug((Object)(this.getBatchId() + " / " + count + "/" + uid + " : envoi invitation"));
                        if (CollectionUtils.isEmpty((Collection)this.dto.getLocalGroups())) {
                            localGroupIds = new ArrayList<String>(0);
                        } else {
                            localGroupIds = new ArrayList(this.dto.getLocalGroups().size());
                            for (CollabProfile localGroup : this.dto.getLocalGroups()) {
                                localGroupIds.add(localGroup.getCn());
                            }
                        }
                        HashMap<String, String> variables = new HashMap<String, String>();
                        variables.put("documentPath", this.dto.getCurrentWorkspace().getPath());
                        variables.put("initiator", this.dto.getInitiator());
                        variables.put("workspaceId", this.dto.getWorkspaceId());
                        variables.put("workspaceTitle", this.dto.getCurrentWorkspace().getTitle());
                        variables.put("uid", uid);
                        variables.put("invitationState", InvitationState.SENT.name());
                        variables.put("role", this.dto.getRole().getId());
                        variables.put("invitationLocalGroups", StringUtils.join(localGroupIds, (String)"|"));
                        variables.put("invitationMessage", this.dto.getMessage());
                        this.startProcedure("invitation", variables);
                        ArrayList groups = new ArrayList();
                        CollabProfile criteria = this.workspaceService.getEmptyProfile();
                        criteria.setWorkspaceId(this.dto.getWorkspaceId());
                        criteria.setRole(WorkspaceRole.ADMIN);
                        groups.addAll(this.workspaceService.findByCriteria(criteria));
                        criteria.setRole(WorkspaceRole.OWNER);
                        groups.addAll(this.workspaceService.findByCriteria(criteria));
                        SetProcedureInstanceAcl command = new SetProcedureInstanceAcl(this.dto.getWorkspaceId(), false, uid, groups);
                        this.getNuxeoController().executeNuxeoCommand((INuxeoCommand)command);
                        invitationsValidated.add(uid);
                        ++countinvitation;
                        logger.debug((Object)(this.getBatchId() + " / " + count + "/" + uid + " : invitation envoy\u00e9e"));
                    } else {
                        ++countwf;
                        this.rejectsPrinter = this.getRejectPrinter();
                        if (this.invitations.contains(uid)) {
                            logger.debug((Object)(this.getBatchId() + " / " + count + "/" + uid + " : d\u00e9j\u00e0 invit\u00e9"));
                            this.rejectsPrinter.printRecord(new Object[]{uid, "D\u00e9j\u00e0 invit\u00e9"});
                        }
                        if (this.requests.contains(uid)) {
                            logger.debug((Object)(this.getBatchId() + " / " + count + "/" + uid + " : demande d'invitation en cours"));
                            this.rejectsPrinter.printRecord(new Object[]{uid, "Demande d'invitation en cours"});
                        }
                        hasRejects = true;
                    }
                }
                ++count;
            }
            if (hasRejects) {
                this.rejectsPrinter.flush();
            }
            this.dto.setCount(count);
            this.dto.setCountalreadymember(countalreadymember);
            this.dto.setCountinvitation(countinvitation);
            this.dto.setCountreject(countreject);
            this.dto.setCountwf(countwf);
            this.sendMailReport();
            if (hasRejects) {
                this.rejectsPrinter.flush();
            }
        }
        catch (FormFilterException | IOException e) {
            throw new PortalException((Exception)e);
        }
        finally {
            this.dto.getTemporaryFile().delete();
            if (this.rejects != null) {
                this.rejects.delete();
            }
        }
    }

    private void populateInvitations(boolean checkRequests) {
        NuxeoController nuxeoController = this.getNuxeoController();
        GetInvitationsCommand invitationsCmd = new GetInvitationsCommand(this.dto.getWorkspaceId(), checkRequests);
        Documents invitationDocs = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)invitationsCmd);
        ArrayList<String> workList = new ArrayList<String>(invitationDocs.size());
        for (Document document : invitationDocs.list()) {
            PropertyMap variables = document.getProperties().getMap("pi:globalVariablesValues");
            String uid = variables.getString("uid");
            InvitationState state = InvitationState.fromName((String)variables.getString("invitationState"));
            if (!InvitationState.SENT.equals((Object)state)) continue;
            workList.add(uid);
        }
        if (checkRequests) {
            this.requests = workList;
        } else {
            this.invitations = workList;
        }
    }

    private void sendMailReport() throws PortalException {
        try {
            Person initiatorPerson = this.personService.getPerson(this.dto.getInitiator());
            String initiatorMail = initiatorPerson.getMail();
            Session mailSession = Session.getInstance((Properties)System.getProperties(), null);
            MimeMessage message = new MimeMessage(mailSession);
            message.setSentDate(new Date());
            String fromProperty = System.getProperty("osivia.procedures.default.mail.from");
            if (fromProperty == null) {
                throw new PortalException("No osivia.procedures.default.mail.from configured !");
            }
            InternetAddress from = new InternetAddress(fromProperty);
            message.setFrom((Address)from);
            InternetAddress[] to = InternetAddress.parse((String)initiatorMail);
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
            String subject = "Import de comptes";
            message.setSubject(subject, "UTF-8");
            boolean attachment = false;
            StringBuilder body = new StringBuilder();
            body.append("<p><b>Rapport d'invitations envoy\u00e9es pour l'espace ");
            body.append(this.dto.getCurrentWorkspace().getTitle());
            body.append("</b></p><p> Invitations envoy\u00e9es : ");
            body.append(this.dto.getCountinvitation());
            body.append("</p>");
            if (this.dto.getCountalreadymember() > 0) {
                attachment = true;
                body.append("<p> Personnes d\u00e9j\u00e0 membres de l'espace : ");
                body.append(this.dto.getCountalreadymember());
                body.append("</p>");
            }
            if (this.dto.getCountwf() > 0) {
                attachment = true;
                body.append("<p> Personnes d\u00e9j\u00e0 invit\u00e9es : ");
                body.append(this.dto.getCountwf());
                body.append("</p>");
            }
            if (this.dto.getCountreject() > 0) {
                attachment = true;
                body.append("<p> Entr\u00e9es invalides dans le fichier : ");
                body.append(this.dto.getCountreject());
                body.append("</p>");
            }
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)body.toString(), "text/html; charset=UTF-8");
            multipart.addBodyPart((BodyPart)htmlPart);
            if (attachment) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(this.rejects);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(this.rejects.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
            SMTPTransport transport = (SMTPTransport)mailSession.getTransport();
            transport.connect();
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (MessagingException e) {
            throw new PortalException("Error sending email report", (Throwable)e);
        }
    }

    private CSVPrinter getRejectPrinter() throws IOException {
        if (this.rejectsPrinter == null) {
            this.rejects = File.createTempFile(this.dto.getWorkspaceId() + "_" + new Date().getTime(), "_rejets.csv");
            this.rejects.createNewFile();
            this.rejectsPrinter = new CSVPrinter((Appendable)new FileWriter(this.rejects), CSVFormat.EXCEL);
        }
        return this.rejectsPrinter;
    }
}

