/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.plugin.forms;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.osivia.services.workspace.util.ApplicationContextProvider;
import org.springframework.context.ApplicationContext;

public class AcceptWorkspaceInvitationFormFilter
implements FormFilter {
    public static final String IDENTIFIER = "ACCEPT_WORKSPACE_INVITATION";
    private static final String LABEL_INTERNATIONALIZATION_KEY = "ACCEPT_WORKSPACE_INVITATION_FORM_FILTER_LABEL";
    private static final String DESCRIPTION_INTERNATIONALIZATION_KEY = null;
    private MemberManagementRepository repository;
    private final PortletContext portletContext;

    public AcceptWorkspaceInvitationFormFilter(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public String getId() {
        return IDENTIFIER;
    }

    public String getLabelKey() {
        return LABEL_INTERNATIONALIZATION_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_INTERNATIONALIZATION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) {
        PortalControllerContext portalControllerContext = context.getPortalControllerContext();
        HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        NuxeoController nuxeoController = new NuxeoController(this.portletContext);
        nuxeoController.setServletRequest(servletRequest);
        Map variables = context.getVariables();
        this.getRepository().acceptInvitation(nuxeoController, variables);
        variables.put("invitationState", InvitationState.ACCEPTED.toString());
        variables.put("acknowledgmentDate", String.valueOf(System.currentTimeMillis()));
        session.setAttribute("osivia.session.reload", (Object)true);
    }

    private MemberManagementRepository getRepository() {
        if (this.repository == null) {
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            this.repository = (MemberManagementRepository)applicationContext.getBean(MemberManagementRepository.class);
        }
        return this.repository;
    }
}

