/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import java.io.IOException;
import java.util.Arrays;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.InvitationRequestsForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MembersSort;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"tab=requests"})
public class MemberManagementRequestsController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        request.setAttribute("tab", (Object)"requests");
        return "requests/view";
    }

    @ActionMapping(value="sort")
    public void sort(ActionRequest request, ActionResponse response, @RequestParam(value="sortId") String sortId, @RequestParam(value="alt") String alt, @ModelAttribute(value="invitationRequests") InvitationRequestsForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.sortInvitationRequests(portalControllerContext, form, MembersSort.fromId((String)sortId), BooleanUtils.toBoolean((String)alt));
        response.setRenderParameter("tab", "requests");
    }

    @ActionMapping(value="accept")
    public void accept(ActionRequest request, ActionResponse response, @RequestParam(value="identifiers") String[] identifiers, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="invitationRequests") InvitationRequestsForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.acceptInvitationRequests(portalControllerContext, options, form, identifiers);
        response.setRenderParameter("tab", "requests");
    }

    @ActionMapping(value="decline")
    public void decline(ActionRequest request, ActionResponse response, @RequestParam(value="identifiers") String[] identifiers, @ModelAttribute(value="options") MemberManagementOptions options, @ModelAttribute(value="invitationRequests") InvitationRequestsForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.declineInvitationRequests(portalControllerContext, options, form, identifiers);
        response.setRenderParameter("tab", "requests");
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ModelAttribute(value="invitationRequests")
    public InvitationRequestsForm getInvitationRequestsForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationRequestsForm(portalControllerContext);
    }

    @ModelAttribute(value="help")
    public String getHelp(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getInvitationRequestsHelp(portalControllerContext);
    }

    @ResourceMapping(value="invitation-requests-toolbar")
    public void getToolbar(ResourceRequest request, ResourceResponse response, @RequestParam(name="indexes", required=false) String indexes) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        Element toolbar = this.service.getInvitationRequestsToolbar(portalControllerContext, Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)indexes), (String)",")));
        response.setContentType("text/html");
        HTMLWriter htmlWriter = new HTMLWriter(response.getPortletOutputStream());
        htmlWriter.write(toolbar);
        htmlWriter.close();
    }
}

