/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.wf.cleaner;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class TtcWfCleaner {
    private static final Log log = LogFactory.getLog((String)"nuxeo.wf.cleaner");

    public int doCleanupDoneAndCanceledRouteInstances(String reprositoryName) {
        UnrestrictedTtcWfCleaner unrestrictedSessionRunner = new UnrestrictedTtcWfCleaner(reprositoryName);
        unrestrictedSessionRunner.runUnrestricted();
        return unrestrictedSessionRunner.getNumberOfCleanedUpWf();
    }

    private final class UnrestrictedTtcWfCleaner
    extends UnrestrictedSessionRunner {
        public static final String DOCUMENT_ROUTE_DONE_CANCEL = "SELECT * FROM DocumentRoute WHERE (ecm:currentLifeCycleState = 'done'  OR ecm:currentLifeCycleState = 'canceled') ORDER BY dc:created";
        private static final String TASK_RELATED = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND nt:processId = '%s' AND ecm:isVersion = 0";
        private static final String OLD_PROC_INSTANCES = "SELECT * FROM Document WHERE ecm:primaryType = 'ProcedureInstance' AND dc:modified <= DATE '%s' ORDER BY dc:created";
        protected int i;
        protected int t;
        protected int p;
        private int routesLimit;
        private int proceduresLimit;

        private UnrestrictedTtcWfCleaner(String repositoryName) {
            super(repositoryName);
            this.i = 0;
            this.t = 0;
            this.p = 0;
            this.routesLimit = Integer.parseInt(Framework.getProperty((String)"foad.nuxeo.wf.clean.routes.limit", (String)"1000"));
            this.proceduresLimit = Integer.parseInt(Framework.getProperty((String)"foad.nuxeo.wf.clean.procedures.limit", (String)"1000"));
        }

        public void run() {
            ElasticSearchService service = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
            if (service != null) {
                NxQueryBuilder queryBuilder = new NxQueryBuilder(this.session);
                queryBuilder.nxql(DOCUMENT_ROUTE_DONE_CANCEL);
                queryBuilder.limit(this.routesLimit);
                DocumentModelList results = service.query(queryBuilder);
                ArrayList<String> routeIds = new ArrayList<String>();
                for (DocumentModel result : results) {
                    routeIds.add(result.getId());
                }
                for (String routeDocId : routeIds) {
                    queryBuilder.nxql(String.format(TASK_RELATED, routeDocId));
                    DocumentModelList tasks = service.query(queryBuilder);
                    this.t = 0;
                    for (DocumentModel task : tasks) {
                        try {
                            this.session.removeDocument((DocumentRef)new IdRef(task.getId()));
                            ++this.t;
                        }
                        catch (ClientException e) {
                            log.error((Object)("Failed to remove task " + task.getId()));
                        }
                    }
                    if (this.t > 0) {
                        log.info((Object)("Remove " + this.t + " task(s)"));
                    }
                    try {
                        this.session.removeDocument((DocumentRef)new IdRef(routeDocId));
                        ++this.i;
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to remove documentroute " + routeDocId));
                    }
                }
                log.info((Object)("Remove " + this.i + " route(s)"));
                Date referenceDate = new Date();
                Calendar c = Calendar.getInstance();
                c.setTime(referenceDate);
                c.add(2, -2);
                referenceDate = c.getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
                String formattedDate = sdf.format(referenceDate);
                queryBuilder.nxql(String.format(OLD_PROC_INSTANCES, formattedDate));
                queryBuilder.limit(this.proceduresLimit);
                DocumentModelList oldPIs = service.query(queryBuilder);
                ArrayList<String> procids = new ArrayList<String>();
                for (DocumentModel pi : oldPIs) {
                    procids.add(pi.getId());
                }
                for (String id : procids) {
                    try {
                        this.session.removeDocument((DocumentRef)new IdRef(id));
                        ++this.p;
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to remove procedure " + id));
                    }
                }
            } else {
                throw new ClientException("TtcWfCleaner requires ElasticsearchService");
            }
            log.info((Object)("Remove " + this.p + " procedure(s)"));
        }

        public int getNumberOfCleanedUpWf() {
            return this.i;
        }
    }
}

