/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.search.portlet.repository;

import fr.gouv.education.foad.common.repository.CommonRepositoryImpl;
import fr.gouv.education.foad.search.portlet.model.TaskPath;
import fr.gouv.education.foad.search.portlet.repository.SearchRepository;
import fr.gouv.education.foad.search.portlet.repository.command.CreateSearchTaskCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class SearchRepositoryImpl
extends CommonRepositoryImpl
implements SearchRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ITaskbarService taskbarService;
    @Autowired
    private IBundleFactory bundleFactory;

    public TaskPath getSearchTaskPath(PortalControllerContext portalControllerContext, String basePath) throws PortletException {
        String cmsPath;
        TaskPath path = (TaskPath)this.applicationContext.getBean(TaskPath.class);
        TaskbarTask task = null;
        try {
            List navigationTasks = this.taskbarService.getTasks(portalControllerContext, basePath, true);
            Iterator iterator = navigationTasks.iterator();
            while (iterator.hasNext() && task == null) {
                TaskbarTask navigationTask = (TaskbarTask)iterator.next();
                if (!StringUtils.equals((String)"SEARCH", (String)navigationTask.getId())) continue;
                task = navigationTask;
            }
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        if (task == null || StringUtils.isEmpty((String)task.getPath())) {
            cmsPath = this.createSearchTask(portalControllerContext, basePath, task);
            path.setUpdated(true);
        } else {
            cmsPath = task.getPath();
        }
        path.setCmsPath(cmsPath);
        return path;
    }

    private String createSearchTask(PortalControllerContext portalControllerContext, String basePath, TaskbarTask task) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if (task == null) {
            TaskbarItem item;
            try {
                item = this.taskbarService.getItem(portalControllerContext, "SEARCH");
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
            task = this.taskbarService.getFactory().createTaskbarTask(item, null, null, false);
        }
        String displayName = bundle.getString(task.getKey(), task.getCustomizedClassLoader(), new Object[0]);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CreateSearchTaskCommand.class, new Object[]{basePath, displayName});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        request.setAttribute("osivia.updateContents", (Object)String.valueOf(true));
        return document.getPath();
    }
}

