/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.portlet.repository;

import fr.gouv.education.foad.portlet.model.FolderTask;
import fr.gouv.education.foad.portlet.model.ServiceTask;
import fr.gouv.education.foad.portlet.model.comparator.FolderTaskComparator;
import fr.gouv.education.foad.portlet.repository.TaskbarRepository;
import fr.gouv.education.foad.portlet.repository.command.MoveDocumentsCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class TaskbarRepositoryImpl
implements TaskbarRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private ITaskbarService taskbarService;
    @Autowired
    private IMenubarService menubarService;
    @Autowired
    private ICMSServiceLocator cmsServiceLocator;
    @Autowired
    private FolderTaskComparator folderTaskComparator;

    public List<TaskbarTask> getNavigationTasks(PortalControllerContext portalControllerContext) throws PortletException {
        List<Object> navigationTasks;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        if (StringUtils.isEmpty((String)basePath)) {
            navigationTasks = new ArrayList<TaskbarTask>(0);
        } else {
            try {
                navigationTasks = this.taskbarService.getTasks(portalControllerContext, basePath, true);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return navigationTasks;
    }

    public List<ServiceTask> getAdministration(PortalControllerContext portalControllerContext) throws PortletException {
        ArrayList<ServiceTask> administration;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        if (StringUtils.isEmpty((String)basePath)) {
            administration = null;
        } else {
            NuxeoDocumentContext workspaceDocumentContext = nuxeoController.getDocumentContext(nuxeoController.getBasePath());
            BasicPermissions permissions = (BasicPermissions)workspaceDocumentContext.getPermissions(BasicPermissions.class);
            if (permissions.isManageableByUser()) {
                Map navbar = this.menubarService.getNavbarSortedItems(portalControllerContext);
                MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "CONFIGURATION");
                Set menubarItems = MapUtils.isEmpty((Map)navbar) || dropdown == null ? null : (Set)navbar.get(dropdown.getGroup());
                if (CollectionUtils.isEmpty(menubarItems)) {
                    administration = null;
                } else {
                    administration = new ArrayList<ServiceTask>(menubarItems.size());
                    for (MenubarItem menubarItem : menubarItems) {
                        ServiceTask service = (ServiceTask)this.applicationContext.getBean(ServiceTask.class);
                        service.setDisplayName(menubarItem.getTitle());
                        service.setUrl(menubarItem.getUrl());
                        service.setIcon(menubarItem.getGlyphicon());
                        administration.add(service);
                    }
                }
            } else {
                administration = null;
            }
        }
        return administration;
    }

    public void generateFolderNavigationTree(PortalControllerContext portalControllerContext, FolderTask folder) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        this.generateFolderChildren(nuxeoController, folder);
    }

    private void generateFolderChildren(NuxeoController nuxeoController, FolderTask parent) throws PortletException {
        SortedSet children = this.getFolderChildren(nuxeoController, parent.getPath());
        parent.setChildren(children);
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (FolderTask child : children) {
                if (!child.isSelected() && child.isLazy()) continue;
                this.generateFolderChildren(nuxeoController, child);
            }
        }
    }

    public SortedSet<FolderTask> getFolderChildren(PortalControllerContext portalControllerContext, String path) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return this.getFolderChildren(nuxeoController, path);
    }

    private SortedSet<FolderTask> getFolderChildren(NuxeoController nuxeoController, String folderPath) throws PortletException {
        TreeSet<FolderTask> children;
        List navigationItems;
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        String basePath = nuxeoController.getBasePath();
        String currentNavigationPath = nuxeoController.getNavigationPath();
        try {
            navigationItems = cmsService.getPortalNavigationSubitems(cmsContext, basePath, folderPath);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)navigationItems)) {
            children = null;
        } else {
            children = new TreeSet<FolderTask>((Comparator<FolderTask>)this.folderTaskComparator);
            for (CMSItem navigationItem : navigationItems) {
                FolderTask child = (FolderTask)this.applicationContext.getBean(FolderTask.class);
                DocumentType documentType = navigationItem.getType();
                Boolean unfetchedChildren = BooleanUtils.toBooleanObject((String)((String)navigationItem.getProperties().get("unfetchedChildren")));
                Document document = (Document)navigationItem.getNativeItem();
                String id = document.getId();
                child.setId(id);
                String path = navigationItem.getPath();
                child.setPath(path);
                String displayName = document.getTitle();
                child.setDisplayName(displayName);
                String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, "menu", null, null, "1", null);
                child.setUrl(url);
                boolean active = StringUtils.equals((String)currentNavigationPath, (String)path);
                child.setActive(active);
                boolean selected = this.isSelected(path, currentNavigationPath);
                child.setSelected(selected);
                boolean folder = documentType != null && documentType.isFolderish();
                child.setFolder(folder);
                boolean lazy = documentType != null && documentType.isBrowsable() && !selected && BooleanUtils.isNotFalse((Boolean)unfetchedChildren);
                child.setLazy(lazy);
                String[] acceptedTypes = this.getAcceptedTypes(navigationItem);
                child.setAcceptedTypes(acceptedTypes);
                children.add(child);
            }
        }
        return children;
    }

    private boolean isSelected(String path, String currentNavigationPath) {
        boolean result = StringUtils.startsWith((String)currentNavigationPath, (String)path);
        if (result) {
            String[] splittedPath = StringUtils.split((String)path, (String)"/");
            String[] splittedCurrentNavigationPath = StringUtils.split((String)currentNavigationPath, (String)"/");
            int index = splittedPath.length - 1;
            result = StringUtils.equals((String)splittedPath[index], (String)splittedCurrentNavigationPath[index]);
        }
        return result;
    }

    private String[] getAcceptedTypes(CMSItem item) {
        List types;
        String[] acceptedTypes = null;
        if (item != null && item.getType() != null && (types = item.getType().getPortalFormSubTypes()) != null) {
            acceptedTypes = types.toArray(new String[types.size()]);
        }
        return acceptedTypes;
    }

    public void moveDocuments(PortalControllerContext portalControllerContext, List<String> sourceIds, String targetId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(MoveDocumentsCommand.class, new Object[]{sourceIds, targetId});
        nuxeoController.executeNuxeoCommand(command);
    }
}

