/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.virusscan;

import fr.index.cloud.ens.virusscan.ICAP;
import fr.index.cloud.ens.virusscan.ICAPResult;
import fr.index.cloud.ens.virusscan.ScanResult;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;

public class ScanChecker {
    private static final Log log = LogFactory.getLog(ScanChecker.class);
    int maxPoolSize = 50;
    int poolSize = 20;
    long keepAliveTime = 30L;
    static ScanChecker instance = null;
    protected ExecutorService threadPool = null;
    long waitingForServerRestart = 0L;

    protected ExecutorService getThreadPool() {
        if (this.threadPool == null) {
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(this.maxPoolSize);
            this.threadPool = new ThreadPoolExecutor(this.poolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, queue);
        }
        return this.threadPool;
    }

    public static ScanChecker getInstance() {
        if (instance == null) {
            instance = new ScanChecker();
        }
        return instance;
    }

    public ScanResult checkFile(DocumentModel docToScan, CoreSession session, boolean save, long timeout) {
        boolean toSave;
        int errorCode;
        block13: {
            errorCode = 2;
            toSave = false;
            BlobHolder bHolder = (BlobHolder)docToScan.getAdapter(BlobHolder.class);
            if (bHolder != null && bHolder.getBlob() != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ScanListener.scan " + bHolder.getBlob().getFilename()));
                    }
                    String ICAPHost = Framework.getProperty((String)"index.antivirus.icap.host");
                    String ICAPPort = Framework.getProperty((String)"index.antivirus.icap.port");
                    if (StringUtils.isNotEmpty((String)ICAPHost) && StringUtils.isNotEmpty((String)ICAPPort)) {
                        if (this.waitingForServerRestart == 0L || System.currentTimeMillis() > this.waitingForServerRestart + 60000L) {
                            this.waitingForServerRestart = 0L;
                            ICAP icap = new ICAP(ICAPHost, Integer.parseInt(ICAPPort), "avscan", bHolder.getBlob().getStream(), bHolder.getBlob().getLength());
                            Future<ICAPResult> future = this.getThreadPool().submit(icap);
                            ICAPResult result = future.get(timeout, TimeUnit.SECONDS);
                            if (result != null) {
                                if (result.getStateProcessing() == 1) {
                                    String virusName = result.getVirusName();
                                    if (virusName == null) {
                                        virusName = "[unknown]";
                                    }
                                    log.warn((Object)("Virus '" + virusName + "' found in " + bHolder.getBlob().getFilename() + "."));
                                    errorCode = 1;
                                }
                                if (result.getStateProcessing() == 0) {
                                    errorCode = 0;
                                    toSave = this.removeFromQuarantine(docToScan, session);
                                }
                            }
                        } else {
                            toSave = this.addToQuarantine(docToScan, session);
                            log.warn((Object)("ICAP Server is not yet reachable . File " + bHolder.getBlob().getFilename() + " is put in quarantine ."));
                        }
                    }
                }
                catch (Exception e) {
                    ExecutionException exec;
                    toSave = this.addToQuarantine(docToScan, session);
                    boolean mustLogError = true;
                    if (e instanceof TimeoutException) {
                        log.warn((Object)("Timeout during scan of " + bHolder.getBlob().getFilename() + " . File is put in quarantine ."));
                        mustLogError = false;
                    }
                    if (e instanceof ExecutionException && ((exec = (ExecutionException)e).getCause() instanceof UnknownHostException || exec.getCause() instanceof IOException)) {
                        log.error((Object)("Error during scan of " + bHolder.getBlob().getFilename() + " : " + exec.getCause().toString() + ".  File is put in quarantine."));
                        this.waitingForServerRestart = System.currentTimeMillis();
                        mustLogError = false;
                    }
                    if (!mustLogError) break block13;
                    log.error((Object)("Error during scan of " + bHolder.getBlob().getFilename() + " . File is put in quarantine ."), (Throwable)e);
                }
            }
        }
        return new ScanResult(errorCode, toSave);
    }

    private boolean addToQuarantine(DocumentModel doc, CoreSession session) {
        if (doc.getProperty("virusScan", "quarantineDate") == null) {
            doc.setProperty("virusScan", "quarantineDate", (Object)new Date());
            return true;
        }
        return false;
    }

    private boolean removeFromQuarantine(DocumentModel doc, CoreSession session) {
        if (doc.getProperty("virusScan", "quarantineDate") != null) {
            doc.setProperty("virusScan", "quarantineDate", null);
            return true;
        }
        return false;
    }
}

