/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

abstract class DoubleValuesComparatorBase<T extends Number>
extends NumberComparatorBase<T> {
    protected final IndexNumericFieldData<?> indexFieldData;
    protected final double missingValue;
    protected double bottom;
    protected DoubleValues readerValues;
    protected final SortMode sortMode;

    public DoubleValuesComparatorBase(IndexNumericFieldData<?> indexFieldData, double missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    public final int compareBottom(int doc) throws IOException {
        double v2 = this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
        return DoubleValuesComparatorBase.compare(this.bottom, v2);
    }

    public int compareTop(int doc) throws IOException {
        return DoubleValuesComparatorBase.compare(((Number)this.top).doubleValue(), this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue));
    }

    public final FieldComparator<T> setNextReader(AtomicReaderContext context) throws IOException {
        this.readerValues = this.indexFieldData.load(context).getDoubleValues();
        return this;
    }

    @Override
    public int compareBottomMissing() {
        return DoubleValuesComparatorBase.compare(this.bottom, this.missingValue);
    }

    static final int compare(double left, double right) {
        return Double.compare(left, right);
    }
}

