/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.FontDialogSwing;
import org.hsqldb.util.GridSwing;
import org.hsqldb.util.RCData;
import org.hsqldb.util.TableSorter;
import org.hsqldb.util.Transfer;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener {
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/dbmanager.rc";
    private static final String HELP_TEXT = "See the forums, mailing lists, and HSQLDB User Guide\nat http://hsqldb.org.\n\nPlease paste the following version identifier with any\nproblem reports or help requests:  $Revision: 1.57 $";
    private static final String ABOUT_TEXT = "$Revision: 1.57 $ of DatabaseManagerSwing\n\nCopyright (c) 1995-2000, The Hypersonic SQL Group.\nCopyright (c) 2001-2005, The HSQL Development Group.\nhttp://hsqldb.org\n\n\nYou may use and redistribute according to the HSQLDB\nlicense documented in the source code and at the web\nsite above.";
    static final String NL = System.getProperty("line.separator");
    static final String NULL_STR = "[null]";
    static int iMaxRecent = 24;
    Connection cConn;
    Connection rowConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    TableModel tableModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    JFrame fMain;
    static boolean bMustExit;
    String ifHuge = "";
    JToolBar jtoolbar;
    private boolean showSchemas = true;
    private boolean showTooltips = true;
    private boolean autoRefresh = true;
    private boolean gridFormat = true;
    static DatabaseManagerSwing refForFontDialogSwing;
    boolean displayRowCounts = false;
    boolean showSys = false;
    boolean showIndexDetails = true;
    String currentLAF = null;
    JPanel pStatus;
    static JButton iReadyStatus;
    JRadioButtonMenuItem rbAllSchemas = new JRadioButtonMenuItem("*");
    JMenuItem mitemAbout = new JMenuItem("About", 65);
    JMenuItem mitemHelp = new JMenuItem("Help", 72);
    JMenuItem mitemUpdateSchemas = new JMenuItem("Update Schemas");
    JCheckBoxMenuItem boxAutoCommit = new JCheckBoxMenuItem("Autocommit mode");
    JCheckBoxMenuItem boxLogging = new JCheckBoxMenuItem("Logging mode");
    JCheckBoxMenuItem boxShowSchemas = new JCheckBoxMenuItem("Show schemas");
    JCheckBoxMenuItem boxAutoRefresh = new JCheckBoxMenuItem("Auto-refresh tree");
    JCheckBoxMenuItem boxTooltips = new JCheckBoxMenuItem("Show Tooltips");
    JCheckBoxMenuItem boxRowCounts = new JCheckBoxMenuItem("Show row counts");
    JCheckBoxMenuItem boxShowGrid = new JCheckBoxMenuItem("Show results in Grid (a.o.t. Text)");
    JCheckBoxMenuItem boxShowSys = new JCheckBoxMenuItem("Show system tables");
    JRadioButtonMenuItem rbNativeLF = new JRadioButtonMenuItem("Native Look & Feel");
    JRadioButtonMenuItem rbJavaLF = new JRadioButtonMenuItem("Java Look & Feel");
    JRadioButtonMenuItem rbMotifLF = new JRadioButtonMenuItem("Motif Look & Feel");
    JLabel jStatusLine;
    static String READY_STATUS;
    private static final String AUTOCOMMIT_BOX_TEXT = "Autocommit mode";
    private static final String LOGGING_BOX_TEXT = "Logging mode";
    private static final String SHOWSCHEMAS_BOX_TEXT = "Show schemas";
    private static final String AUTOREFRESH_BOX_TEXT = "Auto-refresh tree";
    private static final String SHOWTIPS_BOX_TEXT = "Show Tooltips";
    private static final String ROWCOUNTS_BOX_TEXT = "Show row counts";
    private static final String SHOWSYS_BOX_TEXT = "Show system tables";
    private static final String GRID_BOX_TEXT = "Show results in Grid (a.o.t. Text)";
    Cursor fMainCursor;
    Cursor txtCommandCursor;
    Cursor txtResultCursor;
    HashMap tipMap = new HashMap();
    private JMenu mnuSchemas = new JMenu("Schemas");
    private final Cursor waitCursor = new Cursor(3);
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;
    private String schemaFilter = null;
    private DBMPrefs prefs = null;
    Thread dummyThread = new Thread("dummy");
    private String busyText = null;
    private Runnable treeRefreshRunnable = new Runnable(){

        public void run() {
            try {
                DatabaseManagerSwing.this.directRefreshTree();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    };
    private static final String[] usertables;
    private static final String[] nonSystables;
    private static final HashSet oracleSysUsers;
    private static final String[] oracleSysSchemas;
    ActionListener schemaListListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.schemaFilter = actionEvent.getActionCommand();
            if (DatabaseManagerSwing.this.schemaFilter.equals("*")) {
                DatabaseManagerSwing.this.schemaFilter = null;
            }
            DatabaseManagerSwing.this.refreshTree();
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        try {
            this.connect(ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword));
            databaseManagerSwing.setWaiting("Initializing");
            databaseManagerSwing.insertTestData();
            databaseManagerSwing.updateAutoCommitBox();
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            this.setWaiting(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        DatabaseManagerSwing databaseManagerSwing;
        System.getProperties().put("sun.java2d.noddraw", "true");
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].toLowerCase();
            if (string3.length() > 1 && string3.charAt(1) == '-') {
                string3 = string3.substring(1);
            }
            ++i;
            if (string3.equals("-driver")) {
                defDriver = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-url")) {
                defURL = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-user")) {
                defUser = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-password")) {
                defPassword = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-urlid")) {
                string = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string3.equals("-rcfile")) {
                string2 = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string3.equals("-dir")) {
                defDirectory = stringArray[i];
                continue;
            }
            if (string3.equals("-script")) {
                defScript = stringArray[i];
                continue;
            }
            if (string3.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            DatabaseManagerSwing.showUsage();
            return;
        }
        refForFontDialogSwing = databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        Connection connection = null;
        databaseManagerSwing.setWaiting("Initializing");
        try {
            if (bl && bl2) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (bl) {
                connection = ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword);
            } else if (bl2) {
                if (string == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                bl = true;
                String string4 = string2 == null ? DEFAULT_RCFILE : string2;
                RCData rCData = new RCData(new File(string4), string);
                connection = rCData.getConnection(null, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            } else {
                connection = ConnectionDialogSwing.createConnection(databaseManagerSwing.fMain, "Connect");
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            databaseManagerSwing.setWaiting(null);
        }
        if (connection == null) {
            return;
        }
        FontDialogSwing.CreatFontDialog(refForFontDialogSwing);
        databaseManagerSwing.connect(connection);
    }

    public void connect(Connection connection) {
        this.schemaFilter = null;
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                CommonSwing.errorMessage(sQLException);
            }
        }
        this.cConn = connection;
        this.rowConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
            this.updateAutoCommitBox();
            this.showIndexDetails = this.dMeta.getDatabaseProductName().indexOf("Oracle") < 0;
            this.refreshTree();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [--options]\nwhere options include:\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()\n(Single-hypen switches like '-driver' are also supported)");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.executeCurrentSQL();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    public void setMustExit(boolean bl) {
        bMustExit = bl;
    }

    public void main() {
        this.fMain = new JFrame("HSQL Database Manager");
        try {
            this.prefs = new DBMPrefs();
        }
        catch (Exception exception) {
            this.prefs = null;
        }
        if (this.prefs == null) {
            this.setLF(CommonSwing.Native);
        } else {
            this.autoRefresh = this.prefs.autoRefresh;
            this.displayRowCounts = this.prefs.showRowCounts;
            this.showSys = this.prefs.showSysTables;
            this.showSchemas = this.prefs.showSchemas;
            this.gridFormat = this.prefs.resultGrid;
            this.showTooltips = this.prefs.showTooltips;
            this.setLF(this.prefs.laf);
        }
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        this.fMain.setIconImage(CommonSwing.getIcon("Frame"));
        this.fMain.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        Object[] objectArray = new String[]{"-Connect...", "--", "OOpen Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(jMenuBar, "File", objectArray);
        Object[] objectArray2 = new Object[]{"RRefresh Tree", this.boxAutoRefresh, "--", this.boxRowCounts, this.boxShowSys, this.boxShowSchemas, this.boxShowGrid};
        this.addMenu(jMenuBar, "View", objectArray2);
        Object[] objectArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "EEXECUTE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", objectArray3);
        this.mRecent = new JMenu("Recent");
        this.mRecent.setMnemonic(82);
        jMenuBar.add(this.mRecent);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNativeLF);
        buttonGroup.add(this.rbJavaLF);
        buttonGroup.add(this.rbMotifLF);
        this.boxShowSchemas.setSelected(this.showSchemas);
        this.boxShowGrid.setSelected(this.gridFormat);
        this.boxTooltips.setSelected(this.showTooltips);
        this.boxShowGrid.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.boxAutoRefresh.setSelected(this.autoRefresh);
        this.boxRowCounts.setSelected(this.displayRowCounts);
        this.boxShowSys.setSelected(this.showSys);
        this.rbNativeLF.setActionCommand("LFMODE:" + CommonSwing.Native);
        this.rbJavaLF.setActionCommand("LFMODE:" + CommonSwing.Java);
        this.rbMotifLF.setActionCommand("LFMODE:" + CommonSwing.Motif);
        this.tipMap.put(this.mitemUpdateSchemas, "Refresh the schema list in this menu");
        this.tipMap.put(this.rbAllSchemas, "Display items in all schemas");
        this.tipMap.put(this.mitemAbout, "Display product information");
        this.tipMap.put(this.mitemHelp, "Display advice for obtaining help");
        this.tipMap.put(this.boxAutoRefresh, "Refresh tree (and schema list) automaticallywhen YOU modify database objects");
        this.tipMap.put(this.boxShowSchemas, "Display object names in tree like schemaname.basename");
        this.tipMap.put(this.rbNativeLF, "Set Look and Feel to Native for your platform");
        this.tipMap.put(this.rbJavaLF, "Set Look and Feel to Java");
        this.tipMap.put(this.rbMotifLF, "Set Look and Feel to Motif");
        this.boxTooltips.setToolTipText("Display tooltips (hover text), like this");
        this.tipMap.put(this.boxAutoCommit, "Shows current Auto-commit mode.  Click to change");
        this.tipMap.put(this.boxLogging, "Shows current JDBC DriverManager logging mode.  Click to change");
        this.tipMap.put(this.boxShowSys, "Show system tables in table tree to the left");
        this.tipMap.put(this.boxShowGrid, "Show query results in grid (in text if off)");
        this.tipMap.put(this.boxRowCounts, "Show row counts with table names in tree");
        this.boxAutoRefresh.setMnemonic(67);
        this.boxShowSchemas.setMnemonic(89);
        this.boxAutoCommit.setMnemonic(65);
        this.boxShowSys.setMnemonic(89);
        this.boxShowGrid.setMnemonic(71);
        this.boxRowCounts.setMnemonic(67);
        this.boxLogging.setMnemonic(76);
        this.rbAllSchemas.setMnemonic(151);
        this.rbNativeLF.setMnemonic(78);
        this.rbJavaLF.setMnemonic(74);
        this.rbMotifLF.setMnemonic(77);
        this.mitemUpdateSchemas.setMnemonic(85);
        Object[] objectArray4 = new Object[]{this.rbNativeLF, this.rbJavaLF, this.rbMotifLF, "--", "-Set Fonts", "--", this.boxAutoCommit, "CCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", this.boxLogging, "--", "-Insert test data"};
        this.addMenu(jMenuBar, "Options", objectArray4);
        Object[] objectArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        this.addMenu(jMenuBar, "Tools", objectArray5);
        this.mnuSchemas.setMnemonic(83);
        jMenuBar.add(this.mnuSchemas);
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenu.add(this.mitemAbout);
        jMenu.add(this.mitemHelp);
        jMenu.add(this.boxTooltips);
        this.rbAllSchemas.addActionListener(this.schemaListListener);
        this.mitemUpdateSchemas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.updateSchemaList();
            }
        });
        this.mitemHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), DatabaseManagerSwing.HELP_TEXT, "HELP", 1);
            }
        });
        this.mitemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), DatabaseManagerSwing.ABOUT_TEXT, "About", 1);
            }
        });
        this.boxTooltips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.showTooltips = DatabaseManagerSwing.this.boxTooltips.isSelected();
                DatabaseManagerSwing.this.resetTooltips();
            }
        });
        jMenuBar.add(jMenu);
        this.fMain.setJMenuBar(jMenuBar);
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        CommonSwing.setFramePositon(this.fMain);
        this.fMain.setVisible(true);
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.ifHuge = DatabaseManagerCommon.readFile(defScript);
            if (4096 <= this.ifHuge.length()) {
                stringBuffer.append("This huge file cannot be edited. Please execute\n");
                this.txtCommand.setText(stringBuffer.toString());
            } else {
                this.txtCommand.setText(this.ifHuge);
            }
        }
        this.resetTooltips();
        this.txtCommand.requestFocus();
    }

    private void addMenu(JMenuBar jMenuBar, String string, Object[] objectArray) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string.charAt(0));
        this.addMenuItems(jMenu, objectArray);
        jMenuBar.add(jMenu);
    }

    private void addMenuItems(JMenu jMenu, Object[] objectArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < objectArray.length; ++i) {
            JMenuItem jMenuItem;
            if (objectArray[i].equals("--")) {
                jMenu.addSeparator();
                continue;
            }
            if (objectArray[i].equals("---")) {
                if (dimension.width >= 640) {
                    jMenu.addSeparator();
                    continue;
                }
                return;
            }
            if (objectArray[i] instanceof JMenuItem) {
                jMenuItem = (JMenuItem)objectArray[i];
            } else if (objectArray[i] instanceof String) {
                jMenuItem = new JMenuItem(((String)objectArray[i]).substring(1));
                char c = ((String)objectArray[i]).charAt(0);
                if (c != '-') {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 2);
                    jMenuItem.setAccelerator(keyStroke);
                }
            } else {
                throw new RuntimeException("Unexpected element for menu item creation: " + objectArray[i].getClass().getName());
            }
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.executeCurrentSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string != null) {
            if (string.equals("Exit")) {
                this.windowClosing(null);
            } else if (string.equals("Transfer")) {
                Transfer.work(null);
            } else if (string.equals("Dump")) {
                Transfer.work((String[])new String[]{"-d"});
            } else if (string.equals("Restore")) {
                Transfer.work((String[])new String[]{"-r"});
            } else if (string.equals(LOGGING_BOX_TEXT)) {
                JavaSystem.setLogToSystem(this.boxLogging.isSelected());
            } else if (string.equals(AUTOREFRESH_BOX_TEXT)) {
                this.autoRefresh = this.boxAutoRefresh.isSelected();
                this.refreshTree();
            } else if (string.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (string.startsWith("#")) {
                int n = Integer.parseInt(string.substring(1));
                this.txtCommand.setText(this.sRecent[n]);
            } else if (string.equals("Connect...")) {
                Connection connection = null;
                try {
                    this.setWaiting("Connecting");
                    connection = ConnectionDialogSwing.createConnection(this.fMain, "Connect");
                }
                finally {
                    this.setWaiting(null);
                }
                this.connect(connection);
            } else if (string.equals(GRID_BOX_TEXT)) {
                this.gridFormat = this.boxShowGrid.isSelected();
                this.displayResults();
            } else if (string.equals("Open Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Open Script...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showOpenDialog(this.fMain)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    this.ifHuge = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                    if (4096 <= this.ifHuge.length()) {
                        stringBuffer.append("This huge file cannot be edited. Please execute\n");
                        this.txtCommand.setText(stringBuffer.toString());
                    } else {
                        this.txtCommand.setText(this.ifHuge);
                    }
                }
            } else if (string.equals("Save Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Script");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog(this.fMain)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
                }
            } else if (string.equals("Save Result...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Result...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog(this.fMain)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
                }
            } else if (string.equals(SHOWSYS_BOX_TEXT)) {
                this.showSys = this.boxShowSys.isSelected();
                try {
                    this.refreshTree();
                }
                catch (Exception exception) {
                    CommonSwing.errorMessage(exception);
                }
            } else if (string.equals(ROWCOUNTS_BOX_TEXT)) {
                this.displayRowCounts = this.boxRowCounts.isSelected();
                try {
                    this.refreshTree();
                }
                catch (Exception exception) {
                    CommonSwing.errorMessage(exception);
                }
            } else if (string.startsWith("LFMODE:")) {
                this.setLF(string.substring("LFMODE:".length()));
            } else if (string.equals("Set Fonts")) {
                FontDialogSwing.CreatFontDialog(refForFontDialogSwing);
            } else if (string.equals(AUTOCOMMIT_BOX_TEXT)) {
                try {
                    this.cConn.setAutoCommit(this.boxAutoCommit.isSelected());
                }
                catch (SQLException sQLException) {
                    this.boxAutoCommit.setSelected(!this.boxAutoCommit.isSelected());
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Commit")) {
                try {
                    this.cConn.commit();
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Insert test data")) {
                this.insertTestData();
                this.refreshTree();
            } else if (string.equals("Rollback")) {
                try {
                    this.cConn.rollback();
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (string.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (string.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (string.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (string.equals("EXECUTE")) {
                this.executeCurrentSQL();
            } else if (string.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (string.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (string.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (string.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (string.equals("CHECKPOINT")) {
                this.showHelp(DatabaseManagerCommon.checkpointHelp);
            } else if (string.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (string.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (string.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (string.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            } else if (string.equals(SHOWSCHEMAS_BOX_TEXT)) {
                this.showSchemas = this.boxShowSchemas.isSelected();
                this.refreshTree();
            } else {
                throw new RuntimeException("Unexpected action triggered: " + string);
            }
        }
    }

    private void displayResults() {
        if (this.gridFormat) {
            this.setResultsInGrid();
        } else {
            this.setResultsInText();
        }
    }

    private void setResultsInGrid() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.pResult.doLayout();
        this.gResult.fireTableChanged(null);
        this.pResult.repaint();
    }

    private void setResultsInText() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.showResultInText();
        this.pResult.repaint();
    }

    private void showHelp(String[] stringArray) {
        this.txtCommand.setText(stringArray[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(stringArray[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(stringArray[0].length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
            if (this.prefs != null) {
                this.prefs.autoRefresh = this.autoRefresh;
                this.prefs.showRowCounts = this.displayRowCounts;
                this.prefs.showSysTables = this.showSys;
                this.prefs.showSchemas = this.showSchemas;
                this.prefs.resultGrid = this.gridFormat;
                this.prefs.showTooltips = this.showTooltips;
                this.prefs.laf = this.currentLAF;
                this.prefs.store();
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    private void clear() {
        this.ifHuge = "";
        this.txtCommand.setText(this.ifHuge);
    }

    private void backgroundIt(Runnable runnable, String string) {
        if (this.busyText != null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.setWaiting(string);
        SwingUtilities.invokeLater(runnable);
    }

    public void setWaiting(String string) {
        this.busyText = string;
        if (this.busyText == null) {
            this.fMain.setCursor(this.fMainCursor);
            this.txtCommand.setCursor(this.txtCommandCursor);
            this.txtResult.setCursor(this.txtResultCursor);
        } else {
            if (this.fMainCursor == null) {
                this.fMainCursor = this.fMain.getCursor();
                this.txtCommandCursor = this.txtCommand.getCursor();
                this.txtResultCursor = this.txtResult.getCursor();
            }
            this.fMain.setCursor(this.waitCursor);
            this.txtCommand.setCursor(this.waitCursor);
            this.txtResult.setCursor(this.waitCursor);
        }
        this.setStatusLine(this.busyText);
    }

    protected void executeCurrentSQL() {
        this.backgroundIt(new StatementExecRunnable(), "Executing SQL");
    }

    private void executeSQL() {
        Object[] objectArray = new String[1];
        String string = this.txtCommand.getText();
        try {
            this.lTime = System.currentTimeMillis();
            this.sStatement.execute(string);
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                objectArray[0] = "update count";
                this.gResult.setHead(objectArray);
                objectArray[0] = "" + n;
                this.gResult.addRow(objectArray);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            this.addToRecent(string);
        }
        catch (SQLException sQLException) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            objectArray[0] = "SQL Error";
            this.gResult.setHead(objectArray);
            String string2 = sQLException.getMessage();
            string2 = string2 + " / Error Code: " + sQLException.getErrorCode();
            string2 = string2 + " / State: " + sQLException.getSQLState();
            objectArray[0] = string2;
            this.gResult.addRow(objectArray);
            CommonSwing.errorMessage(sQLException);
            return;
        }
        if (this.autoRefresh) {
            this.setStatusLine("Refreshing object tree");
            String string3 = string.toUpperCase(Locale.ENGLISH);
            if (string3.indexOf("ALTER") > -1 || string3.indexOf("DROP") > -1 || string3.indexOf("CREATE") > -1) {
                this.directRefreshTree();
            }
        }
    }

    private void updateResult() {
        if (this.gridFormat) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            Object[] objectArray = new String[]{"Result"};
            this.gResult.setHead(objectArray);
            objectArray[0] = "(empty)";
            this.gResult.addRow(objectArray);
            return;
        }
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            Object[] objectArray = new Object[n2];
            boolean[] blArray = new boolean[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSetMetaData.getColumnLabel(n);
                blArray[n - 1] = resultSetMetaData.getColumnType(n) == 12;
            }
            this.gResult.setHead(objectArray);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    try {
                        objectArray[n - 1] = resultSet.getObject(n);
                        if (!resultSet.wasNull()) continue;
                        objectArray[n - 1] = blArray[n - 1] ? NULL_STR : null;
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void testPerformance() {
        int n;
        String string = this.txtCommand.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 10) continue;
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        Object[] objectArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(objectArray);
        n = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!string.equals("")) {
            String string2;
            int n2 = string.indexOf(59);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            objectArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = DatabaseManagerCommon.testStatement(this.sStatement, string2, n);
                l += l2;
                objectArray[0] = "" + l2;
                objectArray[1] = "" + n;
                objectArray[3] = "";
            }
            catch (SQLException sQLException) {
                objectArray[1] = "n/a";
                objectArray[0] = "n/a";
                objectArray[3] = sQLException.toString();
                CommonSwing.errorMessage(sQLException);
            }
            this.gResult.addRow(objectArray);
            System.out.println(l2 + " ms : " + string2);
        }
        objectArray[0] = "" + l;
        objectArray[1] = "total";
        objectArray[2] = "";
        this.gResult.addRow(objectArray);
        this.lTime = System.currentTimeMillis() - this.lTime;
    }

    private void showResultInText() {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2 = this.gResult.getHead();
        int n3 = objectArray2.length;
        int[] nArray = new int[n3];
        Vector vector = this.gResult.getData();
        int n4 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = objectArray2[n2].toString().length();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray = (Object[])vector.elementAt(n2);
            for (n = 0; n < n3; ++n) {
                String string = objectArray[n] == null ? "" : objectArray[n].toString();
                int n5 = string.length();
                if (n5 <= nArray[n]) continue;
                nArray[n] = n5;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(objectArray2[n]);
            for (int i = objectArray2[n].toString().length(); i <= nArray[n]; ++i) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(NL);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < nArray[n]; ++i) {
                stringBuffer.append('-');
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append(NL);
        for (n = 0; n < n4; ++n) {
            objectArray = (Object[])vector.elementAt(n);
            for (int i = 0; i < n3; ++i) {
                String string = objectArray[i] == null ? "" : objectArray[i].toString();
                stringBuffer.append(string);
                for (int j = string.length(); j <= nArray[i]; ++j) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(NL);
        }
        stringBuffer.append(NL + n4 + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!string.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("#" + this.iRecent);
        jMenuItem.addActionListener(this);
        this.mRecent.insert(jMenuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, jPanel, this.pResult);
        this.nsSplitPane.setOneTouchExpandable(true);
        jPanel.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(5, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(20, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        jPanel.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        TableSorter tableSorter = new TableSorter(this.gResult);
        this.tableModel = tableSorter;
        this.gResultTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.gResultTable.getTableHeader());
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.gResultTable.setAutoResizeMode(0);
        this.gResult.setJTable(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tScrollPane.setPreferredSize(new Dimension(120, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(360, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.ewSplitPane.setOneTouchExpandable(true);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.jStatusLine = new JLabel();
        iReadyStatus = new JButton(new ImageIcon(CommonSwing.getIcon("StatusReady")));
        iReadyStatus.setSelectedIcon(new ImageIcon(CommonSwing.getIcon("StatusRunning")));
        this.pStatus = new JPanel();
        this.pStatus.setLayout(new BorderLayout());
        this.pStatus.add((Component)iReadyStatus, "West");
        this.pStatus.add((Component)this.jStatusLine, "Center");
        this.fMain.getContentPane().add((Component)this.pStatus, "South");
        this.doLayout();
        this.fMain.pack();
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    protected void refreshTree() {
        this.backgroundIt(this.treeRefreshRunnable, "Refreshing object tree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void directRefreshTree() {
        Object object;
        DecimalFormat decimalFormat = new DecimalFormat(" ( ####,###,####,##0 )");
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            object = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent((MutableTreeNode)object);
            ((DefaultMutableTreeNode)object).removeAllChildren();
            ((DefaultMutableTreeNode)object).removeFromParent();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        try {
            String string;
            this.rootNode.setUserObject(this.dMeta.getURL());
            object = this.dMeta.getTables(null, null, null, this.showSys ? usertables : nonSystables);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            while (object.next()) {
                string = object.getString(2);
                if (!this.showSys && this.dMeta.getDatabaseProductName().indexOf("Oracle") > -1 && oracleSysUsers.contains(string) || this.schemaFilter != null && !string.equals(this.schemaFilter)) continue;
                vector2.addElement(string);
                vector.addElement(object.getString(3));
                vector3.addElement(object.getString(5));
            }
            object.close();
            int[] nArray = new int[vector.size()];
            try {
                nArray = this.getRowCounts(vector, vector2);
            }
            catch (Exception exception) {
                CommonSwing.errorMessage(exception);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object var24_26;
                String string2;
                Object object2;
                Object object3;
                String string3;
                String string4 = (String)vector.elementAt(i);
                string = (String)vector2.elementAt(i);
                String string5 = "";
                if (string != null && this.showSchemas) {
                    string5 = string + '.';
                }
                String string6 = this.displayRowCounts ? ", " + decimalFormat.format(nArray[i]) : "";
                String string7 = string5 + string4 + string6;
                DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode(string7, this.rootNode);
                ResultSet resultSet = this.dMeta.getColumns(null, string, string4, null);
                if (string != null && !string.trim().equals("")) {
                    this.makeNode(string, defaultMutableTreeNode);
                }
                if ((string3 = (String)vector3.elementAt(i)) != null && !string3.trim().equals("")) {
                    this.makeNode(string3, defaultMutableTreeNode);
                }
                while (resultSet.next()) {
                    object3 = resultSet.getString(4);
                    object2 = this.makeNode(object3, defaultMutableTreeNode);
                    string2 = resultSet.getString(6);
                    this.makeNode("Type: " + string2, (MutableTreeNode)object2);
                    boolean bl = resultSet.getInt(11) != 0;
                    this.makeNode("Nullable: " + bl, (MutableTreeNode)object2);
                }
                resultSet.close();
                object3 = this.makeNode("Indices", defaultMutableTreeNode);
                object2 = null;
                if (!this.showIndexDetails) continue;
                try {
                    try {
                        object2 = this.dMeta.getIndexInfo(null, string, string4, false, false);
                        string2 = null;
                        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                        while (object2.next()) {
                            boolean bl = object2.getBoolean(4);
                            String string8 = object2.getString(6);
                            if (string2 == null || !string2.equals(string8)) {
                                defaultMutableTreeNode2 = this.makeNode(string8, (MutableTreeNode)object3);
                                this.makeNode("Unique: " + !bl, defaultMutableTreeNode2);
                                string2 = string8;
                            }
                            this.makeNode(object2.getString(9), defaultMutableTreeNode2);
                        }
                        var24_26 = null;
                        if (object2 == null) continue;
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getMessage() == null || !sQLException.getMessage().startsWith("ORA-25191:") && !sQLException.getMessage().startsWith("ORA-01702:") && !sQLException.getMessage().startsWith("ORA-01031:")) {
                            throw sQLException;
                        }
                        var24_26 = null;
                        if (object2 == null) continue;
                        object2.close();
                        object2 = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var24_26 = null;
                    if (object2 != null) {
                        object2.close();
                        object2 = null;
                    }
                    throw throwable;
                }
                object2.close();
                object2 = null;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
            CommonSwing.errorMessage(sQLException);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        this.updateSchemaList();
    }

    void setStatusLine(String string) {
        iReadyStatus.setSelected(string != null);
        if (string == null) {
            String string2 = "";
            if (this.schemaFilter != null) {
                string2 = " /  Tree showing objects in schema '" + this.schemaFilter + "'";
            }
            this.jStatusLine.setText("  " + READY_STATUS + string2);
        } else {
            this.jStatusLine.setText("  " + string + "...");
        }
    }

    protected int[] getRowCounts(Vector vector, Vector vector2) throws Exception {
        if (!this.displayRowCounts) {
            return null;
        }
        String string = "SELECT COUNT(*) FROM ";
        int[] nArray = new int[vector.size()];
        try {
            Statement statement = this.rowConn.createStatement();
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    String string2 = (String)vector2.elementAt(i);
                    string2 = string2 == null ? "" : string2 + '.';
                    String string3 = string2 + (String)vector.elementAt(i);
                    String string4 = string + string3;
                    ResultSet resultSet = statement.executeQuery(string4);
                    while (resultSet.next()) {
                        nArray[i] = resultSet.getInt(1);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Unable to get row count for table " + vector2.elementAt(i) + '.' + vector.elementAt(i) + ".  Using value '0': " + exception);
                }
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        return nArray;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JButton jButton = new JButton("Clear SQL", new ImageIcon(CommonSwing.getIcon("Clear")));
        jButton.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.tipMap.put(jButton, "Clear SQL");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.clear();
            }
        });
        JButton jButton2 = new JButton("Execute SQL", new ImageIcon(CommonSwing.getIcon("Execute")));
        this.tipMap.put(jButton2, "Execute SQL");
        jButton2.putClientProperty("is3DEnabled", Boolean.TRUE);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.executeCurrentSQL();
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jButton.setAlignmentY(0.5f);
        jButton.setAlignmentX(0.5f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setAlignmentX(0.5f);
        return jToolBar;
    }

    void updateAutoCommitBox() {
        try {
            this.boxAutoCommit.setSelected(this.cConn.getAutoCommit());
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void setLF(String string) {
        if (this.currentLAF != null && this.currentLAF == string) {
            return;
        }
        if (this.pResult != null && this.gridFormat) {
            this.pResult.removeAll();
        }
        CommonSwing.setSwingLAF(this.fMain, string);
        if (this.pResult != null && this.gridFormat) {
            this.setResultsInGrid();
        }
        this.currentLAF = string;
        if (this.currentLAF.equals(CommonSwing.Native)) {
            this.rbNativeLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Java)) {
            this.rbJavaLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Motif)) {
            this.rbMotifLF.setSelected(true);
        }
    }

    void resetTooltips() {
        Iterator iterator = this.tipMap.keySet().iterator();
        while (iterator.hasNext()) {
            JComponent jComponent = (JComponent)iterator.next();
            jComponent.setToolTipText(this.showTooltips ? (String)this.tipMap.get(jComponent) : (String)null);
        }
    }

    private void updateSchemaList() {
        Object object;
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object = this.dMeta.getSchemas();
            if (object == null) {
                throw new SQLException("Failed to get metadata from database");
            }
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object = null;
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        this.mnuSchemas.removeAll();
        this.rbAllSchemas.setSelected(this.schemaFilter == null);
        buttonGroup.add(this.rbAllSchemas);
        this.mnuSchemas.add(this.rbAllSchemas);
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((String)object);
            buttonGroup.add(jRadioButtonMenuItem);
            this.mnuSchemas.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(this.schemaFilter != null && this.schemaFilter.equals(object));
            jRadioButtonMenuItem.addActionListener(this.schemaListListener);
            jRadioButtonMenuItem.setEnabled(arrayList.size() > 1);
        }
        this.mnuSchemas.addSeparator();
        this.mnuSchemas.add(this.mitemUpdateSchemas);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        READY_STATUS = "Ready";
        defDriver = "org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:.";
        defUser = "sa";
        defPassword = "";
        usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW", "SYSTEM TABLE"};
        nonSystables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
        oracleSysUsers = new HashSet();
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        for (int i = 0; i < oracleSysSchemas.length; ++i) {
            oracleSysUsers.add(oracleSysSchemas[i]);
        }
    }

    public static class DBMPrefs {
        private File prefsFile = null;
        boolean autoRefresh = true;
        boolean showRowCounts = false;
        boolean showSysTables = false;
        boolean showSchemas = true;
        boolean resultGrid = true;
        String laf = CommonSwing.Native;
        boolean showTooltips = true;
        private static final String tString = Boolean.TRUE.toString();
        private static final String fString = Boolean.FALSE.toString();

        public DBMPrefs() throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
            String string = null;
            try {
                Class<?> clazz = Class.forName("sun.security.action.GetPropertyAction");
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DatabaseManagerSwing.class$("java.lang.String")) : class$java$lang$String);
                PrivilegedAction privilegedAction = (PrivilegedAction)constructor.newInstance("user.home");
                string = (String)AccessController.doPrivileged(privilegedAction);
                this.prefsFile = new File(string, "dbmprefs.properties");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + noSuchMethodException.getMessage() + ')');
                throw noSuchMethodException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + classNotFoundException.getMessage() + ')');
                throw classNotFoundException;
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + instantiationException.getMessage() + ')');
                throw instantiationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + illegalAccessException.getMessage() + ')');
                throw illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + invocationTargetException.getMessage() + ')');
                throw invocationTargetException;
            }
            this.load();
        }

        public void load() {
            Object object;
            Properties properties = new Properties();
            if (!this.prefsFile.exists()) {
                return;
            }
            try {
                object = new FileInputStream(this.prefsFile);
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
            }
            object = properties.getProperty("autoRefresh");
            if (object != null) {
                this.autoRefresh = Boolean.valueOf((String)object);
            }
            if ((object = properties.getProperty("showRowCounts")) != null) {
                this.showRowCounts = Boolean.valueOf((String)object);
            }
            if ((object = properties.getProperty("showSysTables")) != null) {
                this.showSysTables = Boolean.valueOf((String)object);
            }
            if ((object = properties.getProperty("showSchemas")) != null) {
                this.showSchemas = Boolean.valueOf((String)object);
            }
            if ((object = properties.getProperty("resultGrid")) != null) {
                this.resultGrid = Boolean.valueOf((String)object);
            }
            this.laf = (object = properties.getProperty("laf")) == null ? CommonSwing.Native : object;
            object = properties.getProperty("showTooltips");
            if (object != null) {
                this.showTooltips = Boolean.valueOf((String)object);
            }
        }

        public void store() {
            Properties properties = new Properties();
            properties.setProperty("autoRefresh", this.autoRefresh ? tString : fString);
            properties.setProperty("showRowCounts", this.showRowCounts ? tString : fString);
            properties.setProperty("showSysTables", this.showSysTables ? tString : fString);
            properties.setProperty("showSchemas", this.showSchemas ? tString : fString);
            properties.setProperty("resultGrid", this.resultGrid ? tString : fString);
            properties.setProperty("laf", this.laf);
            properties.setProperty("showTooltips", this.showTooltips ? tString : fString);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.prefsFile);
                properties.store(fileOutputStream, "DatabaseManagerSwing user preferences");
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to prepare preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
            }
        }
    }

    protected class StatementExecRunnable
    implements Runnable {
        private String sCmd;

        protected StatementExecRunnable() {
            this.sCmd = 4096 <= DatabaseManagerSwing.this.ifHuge.length() ? DatabaseManagerSwing.this.ifHuge : DatabaseManagerSwing.this.txtCommand.getText();
        }

        public void run() {
            DatabaseManagerSwing.this.gResult.clear();
            try {
                if (this.sCmd.startsWith("-->>>TEST<<<--")) {
                    DatabaseManagerSwing.this.testPerformance();
                } else {
                    DatabaseManagerSwing.this.executeSQL();
                }
                DatabaseManagerSwing.this.updateResult();
                if (DatabaseManagerSwing.this.gridFormat) {
                    DatabaseManagerSwing.this.gResult.fireTableChanged(null);
                }
                DatabaseManagerSwing.this.updateAutoCommitBox();
                System.gc();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    }
}

