/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.externalblob;

import java.io.File;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.externalblob.AbstractExternalBlobAdapter;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;

public class FileSystemExternalBlobAdapter
extends AbstractExternalBlobAdapter {
    private static final long serialVersionUID = 1L;
    public static final String CONTAINER_PROPERTY_NAME = "container";

    public String getFileAbsolutePath(String localPath) throws PropertyException {
        String container = this.getProperty(CONTAINER_PROPERTY_NAME);
        if (container == null) {
            throw new PropertyException(String.format("External blob adapter with prefix '%s' and class '%s' is missing the '%s' property", this.getPrefix(), this.getClass().getName(), CONTAINER_PROPERTY_NAME));
        }
        if (!(container = container.trim()).endsWith(File.separator)) {
            return String.format("%s%s%s", container, File.separator, localPath);
        }
        return String.format("%s%s", container, localPath);
    }

    @Override
    public Blob getBlob(String uri) throws PropertyException {
        String localPath = this.getLocalName(uri);
        String path = this.getFileAbsolutePath(localPath);
        File file = new File(path);
        if (!file.exists()) {
            throw new PropertyException(String.format("Cannot find file at '%s'", path));
        }
        FileBlob blob = new FileBlob(file);
        blob.setFilename(file.getName());
        return blob;
    }
}

