/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.thumbnail;

import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.thumbnail.Thumbnail;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.runtime.api.Framework;

public class ThumbnailAdapter
implements Thumbnail {
    protected final DocumentModel doc;

    public ThumbnailAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public Blob getThumbnail(CoreSession session) throws ClientException {
        ThumbnailService thumbnailService = (ThumbnailService)Framework.getLocalService(ThumbnailService.class);
        return thumbnailService.getThumbnail(this.doc, session);
    }

    public void save(CoreSession session) throws ClientException {
        session.saveDocument(this.doc);
    }

    public String getId() {
        return this.doc.getId();
    }

    @Override
    public Blob computeThumbnail(CoreSession session) throws ClientException {
        ThumbnailService thumbnailService = (ThumbnailService)Framework.getLocalService(ThumbnailService.class);
        return thumbnailService.computeThumbnail(this.doc, session);
    }
}

