/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeOperationHelper {
    private static final Log log = LogFactory.getLog(ToutaticeOperationHelper.class);
    private static AutomationService automationService;

    private ToutaticeOperationHelper() {
    }

    public static void runOperationChain(CoreSession session, String chainId, Object document) throws ToutaticeException {
        OperationContext context = new OperationContext(session);
        context.setInput(document);
        ToutaticeOperationHelper.runOperationChain(session, chainId, context);
    }

    public static void runOperationChain(CoreSession session, String chainId, OperationContext context) throws ToutaticeException {
        try {
            AutomationService automationService = ToutaticeOperationHelper.getAutomationService();
            automationService.run(context, chainId);
        }
        catch (Exception e) {
            ArrayList<String> documentsList = new ArrayList<String>();
            Object input = context.getInput();
            if (input instanceof DocumentModel) {
                documentsList.add(((DocumentModel)input).getName());
            } else if (input instanceof DocumentModelList) {
                for (DocumentModel document : (DocumentModelList)input) {
                    documentsList.add(document.getName());
                }
            }
            log.error((Object)("Failed to run the operation chain '" + chainId + "' on document '" + StringUtils.join(documentsList, (String)",") + "', error: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
    }

    private static AutomationService getAutomationService() throws ClientException {
        if (automationService == null) {
            try {
                automationService = (AutomationService)Framework.getService(AutomationService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to AutomationService. " + e.getMessage();
                log.error((Object)errMsg);
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (automationService == null) {
                String errMsg = "AutomationService service not bound";
                log.error((Object)errMsg);
                throw new ClientException(errMsg);
            }
        }
        return automationService;
    }

    public static Object callOperation(OperationContext ctx, String operationId, Map<String, Object> parameters) throws ToutaticeException {
        Object operationRes = null;
        try {
            AutomationService automationService = ToutaticeOperationHelper.getAutomationService();
            operationRes = automationService.run(ctx, operationId, parameters);
        }
        catch (Exception e) {
            DocumentModel document = (DocumentModel)ctx.getInput();
            log.error((Object)("Failed to run the operation '" + operationId + "' on document '" + document.getName() + "', error: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
        return operationRes;
    }
}

