/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.services.maintenance;

import fr.toutatice.ecm.platform.core.helper.ToutaticeUserMngtHelper;
import fr.toutatice.ecm.platform.core.services.maintenance.ToutaticeMaintenanceService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ToutaticeMaintenanceServiceImpl
extends DefaultComponent
implements ToutaticeMaintenanceService {
    private static final Log log = LogFactory.getLog(ToutaticeMaintenanceServiceImpl.class);
    private static final long DEFAULT_LOG_THRESHOLD = 150L;
    private DocumentModel maintenanceDocument;

    public void activate(ComponentContext context) throws Exception {
        this.setModifiedNow();
        this.maintenanceDocument = null;
    }

    @Override
    public void reloadCfg() {
        this.maintenanceDocument = null;
    }

    @Override
    public long getAutomationLogsThreshold(CoreSession session) {
        long threshold = 150L;
        try {
            DocumentModel mntDoc = this.getOrCreateMntDocument(session);
            if (null != mntDoc) {
                threshold = (Long)mntDoc.getPropertyValue("maintenance:automationLogsThreshold");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to check the automation logs threshold, error: " + e.getMessage()));
        }
        return threshold;
    }

    @Override
    public boolean isAutomationLogsEnabled(CoreSession session) {
        boolean status = false;
        try {
            DocumentModel mntDoc = this.getOrCreateMntDocument(session);
            if (null != mntDoc) {
                Boolean prop = (Boolean)mntDoc.getPropertyValue("maintenance:automationLogsStatus");
                status = prop;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to check the automation logs status, error: " + e.getMessage()));
        }
        return status;
    }

    private DocumentModel getOrCreateMntDocument(CoreSession session) {
        if (null == this.maintenanceDocument) {
            try {
                MntDocumentGetter runner = new MntDocumentGetter(session);
                runner.runUnrestricted();
                this.maintenanceDocument = runner.getMntDocument();
            }
            catch (ClientException e) {
                log.error((Object)("Maintenance document cannot be obtained. cause: " + e.getMessage()));
            }
        }
        return this.maintenanceDocument;
    }

    private class MntDocumentGetter
    extends UnrestrictedSessionRunner {
        private DocumentModel mntDocument;

        public MntDocumentGetter(CoreSession session) {
            super(session);
        }

        public DocumentModel getMntDocument() {
            return this.mntDocument;
        }

        public void run() throws ClientException {
            List<String> administrators = ToutaticeUserMngtHelper.instance().getSuperAdministrators();
            if (0 < administrators.size()) {
                UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
                if (null != userWorkspaceService) {
                    DocumentModel adminUserWorkspace = userWorkspaceService.getUserPersonalWorkspace(administrators.get(0), this.session.getRootDocument());
                    String query = "SELECT * FROM MaintenanceConfiguration WHERE ecm:parentId = '" + adminUserWorkspace.getId() + "'  AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
                    DocumentModelList children = this.session.query(query);
                    if (!children.isEmpty()) {
                        DocumentRef mntDocRef = ((DocumentModel)children.get(0)).getRef();
                        this.mntDocument = this.session.getDocument(mntDocRef);
                    } else {
                        DocumentModel changeableDocument = this.session.createDocumentModel(adminUserWorkspace.getPathAsString(), "MaintenanceConfiguration." + String.valueOf(System.currentTimeMillis()), "MaintenanceConfiguration");
                        this.mntDocument = this.session.createDocument(changeableDocument);
                        this.session.save();
                    }
                    this.mntDocument.detach(true);
                } else {
                    log.error((Object)"Maintenance document cannot be obtained. cause: failed to obtain the user worksapce service");
                }
            } else {
                log.error((Object)"Maintenance document cannot be obtained. cause: no administrator is defined in the user managment configuration.");
            }
        }
    }
}

