/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.comments;

import org.apache.commons.lang.StringUtils;

public enum CommentType {
    COMMENT("Comment", null, "comment"),
    POST("Post", "Thread", "post");

    private static final CommentType DEFAULT;
    private final String type;
    private final String parentType;
    private final String schema;

    private CommentType(String type, String parentType, String schema) {
        this.type = type;
        this.parentType = parentType;
        this.schema = schema;
    }

    public static CommentType fromParentType(String parentType) {
        CommentType result = DEFAULT;
        for (CommentType value : CommentType.values()) {
            if (!StringUtils.equals((String)value.parentType, (String)parentType)) continue;
            result = value;
            break;
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String getParentType() {
        return this.parentType;
    }

    public String getSchema() {
        return this.schema;
    }

    static {
        DEFAULT = COMMENT;
    }
}

