/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.combine;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.combine.ICombinator;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinatorStringWithSeparator
implements ICombinator<String> {
    private final String m_sSep;

    public CombinatorStringWithSeparator(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("separator is null");
        }
        this.m_sSep = string;
    }

    @Override
    public String combine(@Nullable String string, @Nullable String string2) {
        return string + this.m_sSep + string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinatorStringWithSeparator)) {
            return false;
        }
        CombinatorStringWithSeparator combinatorStringWithSeparator = (CombinatorStringWithSeparator)object;
        return this.m_sSep.equals(combinatorStringWithSeparator.m_sSep);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sSep).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("sep", this.m_sSep).toString();
    }
}

