/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.adapters.IteratorShortIterator;
import org.apache.commons.collections.primitives.adapters.ShortCollectionCollection;

abstract class AbstractCollectionShortCollection
implements ShortCollection {
    protected AbstractCollectionShortCollection() {
    }

    @Nonnull
    protected abstract Collection<Short> getCollection();

    @Override
    public boolean add(short s) {
        return this.getCollection().add(s);
    }

    @Override
    public boolean addAll(@Nonnull ShortCollection shortCollection) {
        return this.getCollection().addAll(ShortCollectionCollection.wrap(shortCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(short s) {
        return this.getCollection().contains(s);
    }

    @Override
    public boolean containsAll(@Nonnull ShortCollection shortCollection) {
        return this.getCollection().containsAll(ShortCollectionCollection.wrap(shortCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public ShortIterator iterator() {
        return IteratorShortIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(short s) {
        return this.getCollection().remove(s);
    }

    @Override
    public boolean removeAll(@Nonnull ShortCollection shortCollection) {
        return this.getCollection().removeAll(ShortCollectionCollection.wrap(shortCollection));
    }

    @Override
    public boolean retainAll(@Nonnull ShortCollection shortCollection) {
        return this.getCollection().retainAll(ShortCollectionCollection.wrap(shortCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public short[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        short[] sArray = new short[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            sArray[i] = (Short)objectArray[i];
        }
        return sArray;
    }

    @Override
    @Nonnull
    public short[] toArray(@Nonnull short[] sArray) {
        short[] sArray2 = sArray;
        Object[] objectArray = this.getCollection().toArray();
        if (sArray2.length < objectArray.length) {
            sArray2 = new short[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            sArray2[i] = (Short)objectArray[i];
        }
        return sArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

