/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.virusscan;

import fr.index.cloud.ens.virusscan.ICAPException;
import fr.index.cloud.ens.virusscan.ICAPResult;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ICAP
implements Callable<ICAPResult> {
    private static final int SOCKET_TIMEOUT = 2000;
    private static final Charset StandardCharsetsUTF8 = Charset.forName("UTF-8");
    private static final int BUFFER_SIZE = 32768;
    private static final int STD_RECEIVE_LENGTH = 8192;
    private static final int STD_SEND_LENGTH = 8192;
    private static final String VERSION = "1.0";
    private static final String USERAGENT = "IT-Kartellet ICAP Client/1.1";
    private static final String ICAPTERMINATOR = "\r\n\r\n";
    private static final String HTTPTERMINATOR = "0\r\n\r\n";
    private String serverIP;
    private int port;
    private Socket client;
    private DataOutputStream out;
    private DataInputStream in;
    private String icapService;
    private int stdPreviewSize;
    private String tempString;
    private String originalFilename;
    private InputStream fileInStream;
    private long fileSize;
    private static final Log log = LogFactory.getLog(ICAP.class);

    public ICAP(String serverIP, int port, String icapService, InputStream fileInStream, long fileSize) throws IOException, ICAPException {
        this.icapService = icapService;
        this.serverIP = serverIP;
        this.port = port;
        this.fileInStream = fileInStream;
        this.fileSize = fileSize;
    }

    private void initConnection() throws UnknownHostException, IOException, ICAPException {
        block7: {
            block6: {
                Map<String, String> responseMap;
                Socket client = new Socket();
                client.connect(new InetSocketAddress(this.serverIP, this.port), 2000);
                OutputStream outToServer = client.getOutputStream();
                this.out = new DataOutputStream(new BufferedOutputStream(outToServer, 32768));
                InputStream inFromServer = client.getInputStream();
                this.in = new DataInputStream(inFromServer);
                String parseMe = this.getOptions();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ICAP options = " + parseMe));
                }
                if ((responseMap = this.parseHeader(parseMe)).get("StatusCode") == null) break block6;
                int status = Integer.parseInt(responseMap.get("StatusCode"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ICAP status = " + status));
                }
                switch (status) {
                    case 200: {
                        this.tempString = responseMap.get("Preview");
                        if (this.tempString != null) {
                            this.stdPreviewSize = Integer.parseInt(this.tempString);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        throw new ICAPException("Could not get preview size from server");
                    }
                }
                break block7;
            }
            throw new ICAPException("Could not get options from server");
        }
    }

    @Override
    public ICAPResult call() throws ICAPException, UnknownHostException, IOException {
        try {
            int status;
            this.initConnection();
            String resHeader = "GET /" + this.originalFilename + " HTTP/1.1\r\nHost: " + this.serverIP + ":" + this.port + ICAPTERMINATOR;
            String resBody = resHeader + "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\nContent-Length: " + this.fileSize + ICAPTERMINATOR;
            int previewSize = this.stdPreviewSize;
            if (this.fileSize < (long)this.stdPreviewSize) {
                previewSize = (int)this.fileSize;
            }
            String requestBuffer = "RESPMOD icap://" + this.serverIP + "/" + this.icapService + " ICAP/" + VERSION + "\r\nHost: " + this.serverIP + "\r\nConnection:  close\r\nUser-Agent: " + USERAGENT + "\r\nAllow: 204\r\nPreview: " + previewSize + "\r\nEncapsulated: req-hdr=0, res-hdr=" + resHeader.length() + ", res-body=" + resBody.length() + ICAPTERMINATOR + resBody + Integer.toHexString(previewSize) + "\r\n";
            this.sendString(requestBuffer);
            byte[] chunk = new byte[previewSize];
            this.fileInStream.read(chunk);
            this.sendBytes(chunk);
            this.sendString("\r\n");
            if (this.fileSize <= (long)previewSize) {
                this.sendString("0; ieof\r\n\r\n", true);
            } else if (previewSize != 0) {
                this.sendString(HTTPTERMINATOR, true);
            }
            Map<Object, Object> responseMap = new HashMap();
            if (this.fileSize > (long)previewSize) {
                String parseMe = this.getHeader(ICAPTERMINATOR);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ICAP response(1) = " + parseMe));
                }
                responseMap = this.parseHeader(parseMe);
                this.tempString = (String)responseMap.get("StatusCode");
                if (this.tempString != null) {
                    status = Integer.parseInt(this.tempString);
                    switch (status) {
                        case 100: {
                            break;
                        }
                        case 200: {
                            String virusName = this.extractVirusName(parseMe);
                            ICAPResult iCAPResult = new ICAPResult(1, virusName);
                            return iCAPResult;
                        }
                        case 204: {
                            ICAPResult iCAPResult = new ICAPResult(0);
                            return iCAPResult;
                        }
                        case 404: {
                            throw new ICAPException("404: ICAP Service not found");
                        }
                        default: {
                            throw new ICAPException("Server returned unknown status code:" + status);
                        }
                    }
                }
            }
            if (this.fileSize > (long)previewSize) {
                byte[] buffer = new byte[8192];
                while (this.fileInStream.read(buffer) != -1) {
                    this.sendString(Integer.toHexString(buffer.length) + "\r\n");
                    this.sendBytes(buffer);
                    this.sendString("\r\n");
                }
                requestBuffer = HTTPTERMINATOR;
                this.sendString(requestBuffer, true);
            }
            responseMap.clear();
            String response = this.getHeader(ICAPTERMINATOR);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ICAP response(2) = " + response));
            }
            responseMap = this.parseHeader(response);
            this.tempString = (String)responseMap.get("StatusCode");
            if (this.tempString != null) {
                status = Integer.parseInt(this.tempString);
                if (status == 204) {
                    ICAPResult virusName = new ICAPResult(0);
                    return virusName;
                }
                if (status == 200) {
                    String virusName = this.extractVirusName(response);
                    ICAPResult iCAPResult = new ICAPResult(1, virusName);
                    return iCAPResult;
                }
            }
            throw new ICAPException("Unrecognized or no status code in response header.");
        }
        finally {
            if (this.client != null) {
                this.client.close();
            }
        }
    }

    private String searchVirusBySequence(String response, String begin, String end) {
        int iEnd;
        String virus = null;
        int iBegin = response.indexOf(begin);
        if (iBegin != -1 && (iEnd = response.indexOf(end, iBegin)) != -1) {
            virus = response.substring(iBegin + begin.length(), iEnd);
        }
        return virus;
    }

    private String extractVirusName(String response) {
        String virusName = this.searchVirusBySequence(response, "Threat=", ";");
        if (virusName == null) {
            virusName = this.searchVirusBySequence(response, "X-FSecure-Infection-Name: \"", "\"");
        }
        return virusName;
    }

    private String getOptions() throws IOException, ICAPException {
        String requestHeader = "OPTIONS icap://" + this.serverIP + "/" + this.icapService + " ICAP/" + VERSION + "\r\nHost: " + this.serverIP + "\r\nUser-Agent: " + USERAGENT + "\r\nEncapsulated: null-body=0\r\n\r\n";
        this.sendString(requestHeader, true);
        return this.getHeader(ICAPTERMINATOR);
    }

    private String getHeader(String terminator) throws IOException, ICAPException {
        int n;
        byte[] endofheader = terminator.getBytes(StandardCharsetsUTF8);
        byte[] buffer = new byte[8192];
        int offset = 0;
        while (offset < 8192 && (n = this.in.read(buffer, offset, 1)) != -1) {
            byte[] lastBytes;
            if ((offset += n) <= endofheader.length + 13 || !Arrays.equals(endofheader, lastBytes = Arrays.copyOfRange(buffer, offset - endofheader.length, offset))) continue;
            return new String(buffer, 0, offset, StandardCharsetsUTF8);
        }
        throw new ICAPException("Error in getHeader() method");
    }

    private Map<String, String> parseHeader(String response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        int x = response.indexOf(" ", 0);
        int y = response.indexOf(" ", x + 1);
        String statusCode = response.substring(x + 1, y);
        headers.put("StatusCode", statusCode);
        int i = response.indexOf("\r\n", y);
        i += 2;
        while (i + 2 != response.length() && response.substring(i).contains(":")) {
            int n = response.indexOf(":", i);
            String key = response.substring(i, n);
            i = response.indexOf("\r\n", n += 2);
            String value = response.substring(n, i);
            headers.put(key, value);
            i += 2;
        }
        return headers;
    }

    private void sendString(String requestHeader) throws IOException {
        this.sendString(requestHeader, false);
    }

    private void sendString(String requestHeader, boolean withFlush) throws IOException {
        this.out.write(requestHeader.getBytes(StandardCharsetsUTF8));
        if (withFlush) {
            this.out.flush();
        }
    }

    private void sendBytes(byte[] chunk) throws IOException {
        for (byte aChunk : chunk) {
            this.out.write(aChunk);
        }
    }
}

