/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.api.impl;

import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.NodeType;
import org.nuxeo.ecm.platform.relations.api.exceptions.InvalidLiteralException;
import org.nuxeo.ecm.platform.relations.api.impl.AbstractNode;

public class LiteralImpl
extends AbstractNode
implements Literal {
    private static final long serialVersionUID = 1L;
    protected String value;
    protected String language;
    protected String type;

    public LiteralImpl(String value) {
        this.value = value;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LITERAL;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        if (this.type != null) {
            throw new InvalidLiteralException("Cannot set language, type already set");
        }
        this.language = language;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.language != null) {
            throw new InvalidLiteralException("Cannot set type, language already set");
        }
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        String str = this.type != null ? String.format("%s('%s^^%s')", this.getClass().getSimpleName(), this.value, this.type) : (this.language != null ? String.format("%s('%s@%s')", this.getClass().getSimpleName(), this.value, this.language) : String.format("%s('%s')", this.getClass().getSimpleName(), this.value));
        return str;
    }

    public boolean equals(Object other) {
        boolean sameType;
        boolean sameLanguage;
        if (this == other) {
            return true;
        }
        if (!(other instanceof LiteralImpl)) {
            return false;
        }
        LiteralImpl otherLiteral = (LiteralImpl)other;
        boolean bl = this.language == null ? otherLiteral.language == null : (sameLanguage = this.language.equals(otherLiteral.language));
        boolean bl2 = this.type == null ? otherLiteral.type == null : (sameType = this.type.equals(otherLiteral.type));
        boolean sameValue = this.value == null ? otherLiteral.value == null : this.value.equals(otherLiteral.value);
        return sameLanguage && sameType && sameValue;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 37 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

