/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class RTF2TextConverter
implements Converter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        File f = null;
        try {
            RTFEditorKit rtfParser = new RTFEditorKit();
            Document document = rtfParser.createDefaultDocument();
            rtfParser.read(blobHolder.getBlob().getStream(), document, 0);
            String text = document.getText(0, document.getLength());
            f = File.createTempFile("swing-rtf2text", ".txt");
            FileUtils.writeFile((File)f, (String)text);
            FileBlob blob = new FileBlob((InputStream)new FileInputStream(f));
            blob.setMimeType("text/plain");
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)blob);
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error during Word2Text conversion", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

