/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules.helper;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.osivia.procedures.record.security.rules.model.relation.RelationModel;
import org.osivia.procedures.record.security.rules.model.relation.RelationModelType;

public class RelationModelHelper {
    private RelationModelHelper() {
    }

    public static String getTargetKey(MapProperty recordField) {
        return (String)recordField.get("name").getValue(String.class);
    }

    public static boolean isOneToNRelation(DocumentModel srcModel, String targetKey) {
        ListProperty references = (ListProperty)srcModel.getProperty("pcd:steps/0/globalVariablesReferences");
        return RelationModelHelper.getOneToNRelationIndicator(references, targetKey) != null;
    }

    public static boolean isOneToOneRelation(DocumentModel targetModel, String targetKey) {
        return !RelationModelHelper.isOneToNRelation(targetModel, targetKey);
    }

    public static String getOneToNRelationIndicator(ListProperty references, String targetKey) {
        Iterator iterator = references.iterator();
        boolean typeFound = false;
        String oneToNIndicator = null;
        while (iterator.hasNext() && !typeFound) {
            String[] levels;
            MapProperty ref = (MapProperty)iterator.next();
            String variable = (String)ref.get("variableName").getValue(String.class);
            if (!StringUtils.equals((String)targetKey, (String)variable)) continue;
            typeFound = true;
            String path = (String)ref.get("path").getValue(String.class);
            if (!StringUtils.isNotBlank((String)path) || (levels = StringUtils.split((String)path, (String)",")).length <= 1) continue;
            oneToNIndicator = levels[0];
        }
        return oneToNIndicator;
    }

    @Deprecated
    public static String getOneToNRelationKey(DocumentModel srcModel, String targetKey) {
        String relationKey = "";
        ListProperty references = (ListProperty)srcModel.getProperty("pcd:steps/0/globalVariablesReferences");
        String nToNBaseLevel = RelationModelHelper.getOneToNRelationIndicator(references, targetKey);
        if (StringUtils.isNotBlank((String)nToNBaseLevel)) {
            Iterator iterator = references.iterator();
            boolean parentFound = false;
            while (iterator.hasNext() && !parentFound) {
                MapProperty ref = (MapProperty)iterator.next();
                String path = (String)ref.get("path").getValue(String.class);
                if (!StringUtils.equals((String)nToNBaseLevel, (String)path)) continue;
                parentFound = true;
                relationKey = (String)ref.get("variableName").getValue(String.class);
            }
        }
        return relationKey;
    }

    public static RelationModel buildModel(RelationModelType relationType, String srcType, String targetKey, String targetType) {
        RelationModel relationModel = new RelationModel(relationType);
        relationModel.setSourceType(srcType);
        relationModel.setTargetKey(targetKey);
        relationModel.setTargetType(targetType);
        return relationModel;
    }

    public static String getTargetKey(RelationModelType relationType, DocumentModel model, String targetKey) {
        String key = targetKey;
        if (RelationModelType.oneToN.equals((Object)relationType)) {
            key = RelationModelHelper.getOneToNRelationKey(model, targetKey);
        }
        return key;
    }
}

