/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public final class DocumentPermissionHelper {
    private DocumentPermissionHelper() {
    }

    public static boolean addPermission(ACP acp, String aclName, String userName, String permission, boolean blockInheritance, String currentPrincipalName) {
        boolean securityHasChanged = false;
        ACL acl = acp.getOrCreateACL(aclName);
        List<ACE> aceList = DocumentPermissionHelper.getACEAsList(acl.getACEs());
        ACE aceToAdd = new ACE(userName, permission, true);
        if (blockInheritance) {
            if (StringUtils.isEmpty((String)currentPrincipalName)) {
                throw new IllegalArgumentException("Can't block inheritance without a current principal");
            }
            aceList.clear();
            aceList.add(aceToAdd);
            if (!userName.equals(currentPrincipalName)) {
                aceList.add(new ACE(currentPrincipalName, "Everything", true));
            }
            aceList.addAll(DocumentPermissionHelper.getAdminEverythingACES());
            aceList.add(DocumentPermissionHelper.getBlockInheritanceACE());
            securityHasChanged = true;
        } else if (DocumentPermissionHelper.shouldAddACEToACL(aceList, aceToAdd)) {
            int pos = aceList.indexOf(DocumentPermissionHelper.getBlockInheritanceACE());
            if (pos >= 0) {
                aceList.add(pos, aceToAdd);
            } else {
                aceList.add(aceToAdd);
            }
            securityHasChanged = true;
        }
        acl.setACEs(aceList.toArray(new ACE[aceList.size()]));
        if (securityHasChanged) {
            acp.addACL(acl);
        }
        return securityHasChanged;
    }

    private static boolean shouldAddACEToACL(List<ACE> aceList, ACE aceToAdd) {
        boolean shouldAddPermission = true;
        for (ACE ace : aceList) {
            if (!aceToAdd.equals((Object)ace)) continue;
            shouldAddPermission = false;
        }
        return shouldAddPermission;
    }

    private static ACE getBlockInheritanceACE() {
        return new ACE("Everyone", "Everything", false);
    }

    private static List<ACE> getAdminEverythingACES() {
        ArrayList<ACE> result = new ArrayList<ACE>();
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        List administratorsGroups = um.getAdministratorsGroups();
        for (String adminGroup : administratorsGroups) {
            result.add(new ACE(adminGroup, "Everything", true));
        }
        return result;
    }

    private static List<ACE> getACEAsList(ACE[] acEs) {
        ArrayList<ACE> aces = new ArrayList<ACE>();
        aces.addAll(Arrays.asList(acEs));
        return aces;
    }

    public static boolean removePermission(ACP acp, String aclName, String principalName) {
        boolean securityHasChanged = false;
        ACL acl = acp.getACL(aclName);
        if (acl != null) {
            Object[] acEs;
            for (ACE aCE : acEs = acl.getACEs()) {
                if (!aCE.getUsername().equals(principalName)) continue;
                acEs = (ACE[])ArrayUtils.removeElement((Object[])acEs, (Object)aCE);
                securityHasChanged = true;
            }
            acl.setACEs((ACE[])acEs);
        }
        if (securityHasChanged) {
            acp.addACL(acl);
        }
        return securityHasChanged;
    }
}

