/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.faces.FacesException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceLibrary;
import org.richfaces.resource.ResourceLibraryFactory;
import org.richfaces.resource.StaticResourceLibrary;
import org.richfaces.util.FastJoiner;
import org.richfaces.util.PropertiesUtil;

public class ResourceLibraryFactoryImpl
implements ResourceLibraryFactory {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final FastJoiner SLASH_JOINER = FastJoiner.on('/');
    private static final Splitter COMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private LoadingCache<ResourceKey, ResourceLibrary> instances = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<ResourceKey, ResourceLibrary>(){

        public ResourceLibrary apply(ResourceKey from) {
            String propsResourceName = from.getResourceName() + ".library.properties";
            Map<String, String> props = PropertiesUtil.loadProperties("META-INF/richfaces/" + SLASH_JOINER.join(from.getLibraryName(), propsResourceName));
            String libraryClass = props.get("class");
            String resources = props.get("resources");
            if (libraryClass != null) {
                try {
                    Class<?> clazz = Class.forName(libraryClass.trim(), false, Thread.currentThread().getContextClassLoader());
                    return (ResourceLibrary)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error(e.getMessage(), e);
                }
                catch (InstantiationException e) {
                    LOGGER.error(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error(e.getMessage(), e);
                }
            } else {
                if (resources != null) {
                    Iterable keys = Iterables.transform((Iterable)COMA_SPLITTER.split((CharSequence)resources), ResourceKey.FACTORY);
                    return new StaticResourceLibrary((ResourceKey[])Iterables.toArray((Iterable)keys, ResourceKey.class));
                }
                LOGGER.error("'class' or 'resources' properties should be declared in library descriptor: " + from);
            }
            return null;
        }
    }));

    @Override
    public ResourceLibrary getResourceLibrary(String name, String library) {
        ResourceKey resourceKey = new ResourceKey(name, library);
        try {
            return (ResourceLibrary)this.instances.get((Object)resourceKey);
        }
        catch (ExecutionException e) {
            throw new FacesException(String.format("Can't resolve resource library %s", resourceKey), (Throwable)e);
        }
    }
}

