/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.lang.LangNTuple;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangNQuads
extends LangNTuple<Quad> {
    private Node currentGraph = null;

    public LangNQuads(Tokenizer tokens2, ParserProfile profile, Sink<Quad> sink) {
        super(tokens2, profile, sink);
    }

    @Override
    public Lang getLang() {
        return Lang.NQUADS;
    }

    @Override
    protected final Quad parseOne() {
        Token xToken;
        Token oToken;
        Token pToken;
        Token sToken = this.nextToken();
        if (sToken.getType() == TokenType.EOF) {
            this.exception(sToken, "Premature end of file: %s", sToken);
        }
        if ((pToken = this.nextToken()).getType() == TokenType.EOF) {
            this.exception(pToken, "Premature end of file: %s", pToken);
        }
        if ((oToken = this.nextToken()).getType() == TokenType.EOF) {
            this.exception(oToken, "Premature end of file: %s", oToken);
        }
        if ((xToken = this.nextToken()).getType() == TokenType.EOF) {
            this.exception(xToken, "Premature end of file: Quad not terminated by DOT: %s", xToken);
        }
        Node c = null;
        if (xToken.getType() != TokenType.DOT) {
            this.checkIRI(xToken);
            c = this.tokenAsNode(xToken);
            xToken = this.nextToken();
            this.currentGraph = c;
        } else {
            c = Quad.defaultGraphNodeGenerated;
            this.currentGraph = null;
        }
        this.checkIRIOrBNode(sToken);
        this.checkIRI(pToken);
        this.checkRDFTerm(oToken);
        Node s = this.tokenAsNode(sToken);
        Node p = this.tokenAsNode(pToken);
        Node o = this.tokenAsNode(oToken);
        if (xToken.getType() != TokenType.DOT) {
            this.exception(xToken, "Quad not terminated by DOT: %s", xToken);
        }
        return this.profile.createQuad(c, s, p, o, sToken.getLine(), sToken.getColumn());
    }

    @Override
    protected final Node tokenAsNode(Token token) {
        return this.profile.create(this.currentGraph, token);
    }
}

