/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.ejb.SeamInterceptor;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.RootInterceptor;
import org.jboss.seam.intercept.RootInvocationContext;
import org.jboss.seam.intercept.SessionBeanInterceptor;

public class ClientSideInterceptor
extends RootInterceptor
implements MethodHandler {
    private static final long serialVersionUID = -1578313703571846699L;
    private final Object bean;
    private final Class beanClass;

    public ClientSideInterceptor(Object bean, Component component) {
        super(InterceptorType.CLIENT);
        this.bean = bean;
        this.beanClass = component.getBeanClass();
        this.init(component);
    }

    public Object invoke(Object proxy, Method method, Method proceed, Object[] params) throws Throwable {
        Object result;
        String methodName = method.getName();
        if (params != null && params.length == 0) {
            if ("finalize".equals(methodName)) {
                return proceed.invoke(proxy, params);
            }
            if ("writeReplace".equals(methodName)) {
                return this;
            }
            if ("getComponent".equals(methodName)) {
                return this.getComponent();
            }
        }
        return this.sessionBeanReturnedThis(result = this.invoke(this.createInvocationContext(method, params), EventType.AROUND_INVOKE)) ? proxy : result;
    }

    private boolean sessionBeanReturnedThis(Object result) {
        return result == this.bean || result != null && this.getComponent().getBeanClass().isAssignableFrom(result.getClass());
    }

    private RootInvocationContext createInvocationContext(Method method, Object[] params) {
        return new RootInvocationContext(this.bean, method, params){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object proceed() throws Exception {
                Component old = SessionBeanInterceptor.COMPONENT.get();
                SeamInterceptor.COMPONENT.set(ClientSideInterceptor.this.getComponent());
                try {
                    Object object = super.proceed();
                    return object;
                }
                finally {
                    SeamInterceptor.COMPONENT.set(old);
                }
            }
        };
    }

    Object readResolve() {
        Component comp = null;
        try {
            comp = this.getComponent();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            if (comp == null) {
                ProxyObject proxy = Component.createProxyFactory(ComponentType.STATEFUL_SESSION_BEAN, this.beanClass, Component.getBusinessInterfaces(this.beanClass)).newInstance();
                proxy.setHandler((MethodHandler)this);
                return proxy;
            }
            return comp.wrap(this.bean, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

