/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.webengine.jaxrs.servlet.RequestChain;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ListenerSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletRegistry;

public class ServletHolder
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected RequestChain chain;
    protected ServletDescriptor descriptor;
    protected volatile boolean initDone = false;

    protected String getName(ServletConfig config) {
        String name = config.getInitParameter(ServletRegistry.SERVLET_NAME);
        if (name == null) {
            name = config.getServletName();
        }
        return name;
    }

    protected ServletDescriptor getDescriptor(ServletConfig config) throws ServletException {
        String name = this.getName(config);
        if (name == null) {
            throw new ServletException("No name defined for the ServletHolder. Check your servlet contributions.");
        }
        ServletDescriptor desc = ServletRegistry.getInstance().getServletDescriptor(name);
        if (desc == null) {
            throw new ServletException("No such servlet descriptor: " + name);
        }
        return desc;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.descriptor = this.getDescriptor(config);
            this.chain = new RequestChain(this.descriptor.getServlet(), this.descriptor.getFilters());
            ListenerSetDescriptor listeners = this.descriptor.getListenerSet();
            if (listeners != null) {
                listeners.init(config);
            }
            super.init(config);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Initialization exception for servlet " + config.getServletName(), (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        this.initDone = false;
        if (this.chain != null) {
            this.chain.destroy();
            this.chain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        try {
            if (!this.initDone) {
                this.lazyInit();
            }
            t.setContextClassLoader(this.chain.servlet.getClass().getClassLoader());
            this.chain.execute((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    protected synchronized void lazyInit() throws ServletException {
        try {
            this.chain.init(this.descriptor, this.getServletConfig());
        }
        finally {
            this.initDone = true;
        }
    }
}

