/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.onlyoffice.automation;

import fr.toutatice.ecm.platform.core.edition.EditionCacheHelper;
import java.util.HashMap;
import net.sf.json.JSONArray;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Document.LockTemporary", category="Document", label="Lock a document before editing a document.", description="Lock a document before editing a document, the lock is removed when onlyoffice edition is done.")
public class LockTemporary {
    public static final String ID = "Document.LockTemporary";
    private static final Log log = LogFactory.getLog(LockTemporary.class);
    @Context
    protected CoreSession coreSession;
    @Param(name="id")
    protected DocumentModel currentDocument;

    @OperationMethod
    public Object run() throws Exception {
        JSONArray json = new JSONArray();
        HashMap<String, String> infos = new HashMap<String, String>();
        try {
            this.coreSession.setLock(this.currentDocument.getRef());
            EditionCacheHelper.put((DocumentModel)this.currentDocument, (String)this.coreSession.getPrincipal().getName(), (String)"temporary-locked-cache");
            infos.put("error", "0");
        }
        catch (ClientException e) {
            infos.put("error", "1");
        }
        json.add(infos);
        return new StringBlob(json.toString(), "application/json");
    }
}

