/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeElasticSearchInlineListener
implements EventListener {
    public static final Log log = LogFactory.getLog(ToutaticeElasticSearchInlineListener.class);
    public static final String ELASTICSEARCH_LISTENER_ID = "elasticSearchInlineListener";
    private EventService eventService;

    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext ctx = (DocumentEventContext)event.getContext();
            DocumentModel document = ctx.getSourceDocument();
            String originalEvtName = (String)((Object)ctx.getProperty("originalEventName"));
            EventListenerDescriptor listenerDesc = this.getEventService().getEventListener(ELASTICSEARCH_LISTENER_ID);
            if (null != document && null != listenerDesc && listenerDesc.isEnabled() && listenerDesc.acceptEvent(originalEvtName)) {
                DocumentModelList proxies;
                EventImpl docEvt = new EventImpl(originalEvtName, event.getContext());
                listenerDesc.asEventListener().handleEvent((Event)docEvt);
                log.debug((Object)("ElasticSearch: re-indexed the document '" + document.getPathAsString() + "'"));
                if (document.isVersion() && null != (proxies = ToutaticeDocumentHelper.getProxies(ctx.getCoreSession(), document, ToutaticeGlobalConst.CST_TOUTATICE_PROXY_LOOKUP_SCOPE.GLOBAL, null, true)) && 0 < proxies.size()) {
                    for (DocumentModel proxy : proxies) {
                        DocumentEventContext proxyCtx = new DocumentEventContext(ctx.getCoreSession(), ctx.getPrincipal(), proxy);
                        EventImpl proxyEvt = new EventImpl(originalEvtName, (EventContext)proxyCtx);
                        listenerDesc.asEventListener().handleEvent((Event)proxyEvt);
                        log.debug((Object)("ElasticSearch: re-indexed the document's proxy'" + proxy.getPathAsString() + "'"));
                    }
                }
            }
        }
    }

    private EventService getEventService() throws ClientException {
        if (null == this.eventService) {
            this.eventService = (EventService)Framework.getService(EventService.class);
        }
        if (null == this.eventService) {
            throw new ClientException("failed to instanciate the 'EventService'");
        }
        return this.eventService;
    }
}

