/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.platform.portal.notifications.veto;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerVeto;

public class NotificationVeto
implements NotificationListenerVeto {
    private static final Log log = LogFactory.getLog(NotificationVeto.class);
    public static final String[] authorizedSystemEvents = new String[]{"workflowProcessCanceled", "workflowAbandoned", "workflowTaskAssigned", "workflowTaskCompleted", "workflowTaskRejected"};

    public boolean accept(Event event) throws Exception {
        if (event.getContext() instanceof DocumentEventContext) {
            NuxeoPrincipal originatingPrincipal;
            String eventName = event.getName();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            if (docCtx.getSourceDocument() != null) {
                String sourceDocumentType = docCtx.getSourceDocument().getType();
                boolean folderish = docCtx.getSourceDocument().hasFacet("Folderish");
                if (folderish ? !event.getName().equals("ttcDocumentTrashed") : sourceDocumentType.equals("Staple")) {
                    return false;
                }
            }
            return !this.blockSystemEvents(eventName, originatingPrincipal = (NuxeoPrincipal)docCtx.getPrincipal());
        }
        return false;
    }

    protected boolean blockSystemEvents(String eventName, NuxeoPrincipal principal) {
        boolean block = false;
        if (StringUtils.equalsIgnoreCase((String)"system", (String)principal.getName())) {
            block = !Arrays.asList(authorizedSystemEvents).contains(eventName);
        }
        return block;
    }
}

