/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.servlet;

import java.io.IOException;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DebugServlet
extends HttpServlet {
    private static final long serialVersionUID = 4235895566712482208L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        String path = req.getPathInfo();
        if (path == null) {
            path = "java:comp/env";
        }
        try {
            InitialContext ctx = new InitialContext();
            StringBuffer buf = new StringBuffer();
            buf.append(">>>> GLOBAL: \r\n");
            this.list(ctx, ">> ", buf, true);
            Object o = ctx.lookup("java:");
            if (o instanceof Context) {
                buf.append("----------------------------------------------\r\n");
                buf.append(">>>> JAVA: \r\n");
                this.list((Context)o, ">> ", buf, true);
            }
            System.out.println(buf.toString());
            resp.getWriter().write(buf.toString());
            o = ctx.lookup("jdbc/nxsqldirectory");
            System.out.println(">>NXQLDIR: " + o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void list(Context ctx, String indent, StringBuffer buffer, boolean verbose) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                Class<?> c;
                boolean isProxy;
                boolean isLinkRef;
                boolean recursive;
                String className;
                String name;
                NameClassPair pair;
                block21: {
                    pair = ne.next();
                    name = pair.getName();
                    className = pair.getClassName();
                    recursive = false;
                    isLinkRef = false;
                    isProxy = false;
                    c = null;
                    try {
                        c = loader.loadClass(className);
                        if (Context.class.isAssignableFrom(c)) {
                            recursive = true;
                        }
                        if (LinkRef.class.isAssignableFrom(c)) {
                            isLinkRef = true;
                        }
                        isProxy = Proxy.isProxyClass(c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!className.startsWith("$Proxy")) break block21;
                        isProxy = true;
                        try {
                            Object p = ctx.lookup(name);
                            c = p.getClass();
                        }
                        catch (NamingException e) {
                            String msg;
                            Throwable t = e.getRootCause();
                            if (!(t instanceof ClassNotFoundException) || (msg = t.getMessage()) == null) break block21;
                            className = msg;
                        }
                    }
                }
                buffer.append(indent).append(" +- ").append(name);
                if (isLinkRef) {
                    try {
                        Object obj = ctx.lookupLink(name);
                        Class<?>[] link = (Class<?>[])obj;
                        buffer.append("[link -> ");
                        buffer.append(link.getLinkName());
                        buffer.append(']');
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (isProxy) {
                    buffer.append(" (proxy: ").append(pair.getClassName());
                    if (c != null) {
                        Class<?>[] ifaces = c.getInterfaces();
                        buffer.append(" implements ");
                        for (Class<?> iface : ifaces) {
                            buffer.append(iface);
                            buffer.append(',');
                        }
                        buffer.setCharAt(buffer.length() - 1, ')');
                    } else {
                        buffer.append(" implements ").append(className).append(")");
                    }
                } else if (verbose) {
                    buffer.append(" (class: ").append(pair.getClassName()).append(")");
                }
                buffer.append('\n');
                if (!recursive) continue;
                try {
                    Object value = ctx.lookup(name);
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        this.list(subctx, indent + " |  ", buffer, verbose);
                        continue;
                    }
                    buffer.append(indent).append(" |   NonContext: ").append(value);
                    buffer.append('\n');
                }
                catch (Throwable t) {
                    buffer.append("Failed to lookup: ").append(name).append(", errmsg=").append(t.getMessage()).append('\n');
                }
            }
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }
}

