/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class FulltextUpdaterWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FulltextUpdaterWork.class);
    public static final String SYSPROP_FULLTEXT_SIMPLE = "fulltextSimple";
    public static final String SYSPROP_FULLTEXT_BINARY = "fulltextBinary";
    public static final String SYSPROP_FULLTEXT_JOBID = "fulltextJobId";
    public static final String FULLTEXT_DEFAULT_INDEX = "default";
    protected static final String CATEGORY = "fulltextUpdater";
    protected static final String TITLE = "Fulltext Updater";
    protected final boolean isSimpleText;
    protected final boolean isJob;
    protected final List<IndexAndText> indexesAndText;

    public FulltextUpdaterWork(String repositoryName, String docId, boolean isSimpleText, boolean isJob, List<IndexAndText> indexesAndText) {
        this.setDocument(repositoryName, docId);
        this.isSimpleText = isSimpleText;
        this.isJob = isJob;
        this.indexesAndText = indexesAndText;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return TITLE;
    }

    public int getRetryCount() {
        return 1;
    }

    public void work() throws Exception {
        this.initSession();
        if (this.session.getPrincipal() == null) {
            return;
        }
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        this.setStatus("Updating");
        this.update();
        this.setStatus("Saving");
        this.session.save();
        this.setStatus("Done");
    }

    protected void update() throws ClientException {
        DocumentModel doc;
        Object docs;
        if (this.isJob) {
            String query = String.format("SELECT * FROM Document WHERE ecm:fulltextJobId = '%s' AND ecm:isProxy = 0", this.docId);
            docs = this.session.query(query);
        } else {
            IdRef ref = new IdRef(this.docId);
            if (!this.session.exists((DocumentRef)ref)) {
                return;
            }
            doc = this.session.getDocument((DocumentRef)ref);
            if (doc.isProxy()) {
                return;
            }
            docs = Collections.singleton(doc);
        }
        Iterator iterator = docs.iterator();
        while (iterator.hasNext()) {
            doc = (DocumentModel)iterator.next();
            for (IndexAndText indexAndText : this.indexesAndText) {
                try {
                    this.session.setDocumentSystemProp(doc.getRef(), this.getFulltextPropertyName(indexAndText.indexName), (Serializable)((Object)indexAndText.text));
                }
                catch (DocumentException e) {
                    log.error((Object)("Could not set fulltext on: " + doc.getId()), (Throwable)e);
                }
            }
        }
        if (this.isJob) {
            iterator = docs.iterator();
            while (iterator.hasNext()) {
                doc = (DocumentModel)iterator.next();
                try {
                    this.session.setDocumentSystemProp(doc.getRef(), SYSPROP_FULLTEXT_JOBID, null);
                }
                catch (DocumentException e) {
                    log.error((Object)("Could not set fulltext on: " + doc.getId()), (Throwable)e);
                }
            }
        }
    }

    protected String getFulltextPropertyName(String indexName) {
        String name;
        String string = name = this.isSimpleText ? SYSPROP_FULLTEXT_SIMPLE : SYSPROP_FULLTEXT_BINARY;
        if (!FULLTEXT_DEFAULT_INDEX.equals(indexName)) {
            name = name + '_' + indexName;
        }
        return name;
    }

    public static class IndexAndText
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String indexName;
        public String text;

        public IndexAndText(String indexName, String text) {
            this.indexName = indexName;
            this.text = text;
        }
    }
}

