/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.jwt.authentication;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.osivia.jwt.service.JWTTokenService;

public class JWTTokenAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final String ALLOW_ANONYMOUS_KEY = "allowAnonymous";
    private static final String ALGORITHM_ID_KEY = "algorithmId";
    private static final Log log = LogFactory.getLog(JWTTokenAuthenticator.class);
    protected static final String TOKEN_HEADER = "Authorization";
    protected static final String TOKEN_PARAM = "token";
    private static final String TOKEN_PREFIX = "Bearer";
    protected String algorithmId;
    protected boolean allowAnonymous = false;
    private JWTTokenService jWTTokenService;

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return false;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String token = this.getTokenFromRequest(httpRequest);
        if (token == null) {
            log.debug((Object)"Found no token in the request.");
            return null;
        }
        String userName = this.getUserByToken(token);
        if (userName == null) {
            log.debug((Object)String.format("No user bound to the token '%s' (maybe it has been revoked), returning null.", token));
            return null;
        }
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        if (userManager != null && userName.equals(userManager.getAnonymousUserId()) && !this.allowAnonymous) {
            log.debug((Object)"Anonymous user is not allowed to get authenticated by token, returning null.");
            return null;
        }
        return new UserIdentificationInfo(userName, userName);
    }

    private String getTokenFromRequest(HttpServletRequest httpRequest) {
        String token = httpRequest.getParameter(TOKEN_PARAM);
        if (token == null) {
            token = this.getTokenFromHeader(httpRequest);
        }
        return token;
    }

    private String getTokenFromHeader(HttpServletRequest httpRequest) {
        String token = null;
        String headerValue = httpRequest.getHeader(TOKEN_HEADER);
        if (StringUtils.isNotBlank((String)headerValue) && StringUtils.startsWith((String)headerValue, (String)TOKEN_PREFIX)) {
            token = StringUtils.trim((String)StringUtils.removeStart((String)headerValue, (String)TOKEN_PREFIX));
        }
        return token;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return false;
    }

    public void initPlugin(Map<String, String> parameters) {
        if (parameters.containsKey(ALLOW_ANONYMOUS_KEY)) {
            this.allowAnonymous = Boolean.valueOf(parameters.get(ALLOW_ANONYMOUS_KEY));
        }
        if (parameters.containsKey(ALGORITHM_ID_KEY)) {
            this.algorithmId = parameters.get(ALGORITHM_ID_KEY);
        }
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    protected String getUserByToken(String token) {
        Map<String, Object> payload = this.getJWTTokenService().getPayload(token, this.algorithmId);
        String userId = (String)payload.get("userId");
        return userId;
    }

    protected JWTTokenService getJWTTokenService() {
        if (this.jWTTokenService == null) {
            this.jWTTokenService = (JWTTokenService)Framework.getService(JWTTokenService.class);
        }
        return this.jWTTokenService;
    }
}

