/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util.jar;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.nuxeo.osgi.util.jar.URLJarFileIntrospector;

public class URLClassLoaderCloser {
    protected List<?> loaders;
    protected final URLJarFileIntrospector introspector;
    protected final Map<?, ?> index;

    public URLClassLoaderCloser(URLJarFileIntrospector anIntrospector, Map<?, ?> anIndex, List<?> someLoaders) {
        this.introspector = anIntrospector;
        this.index = anIndex;
        this.loaders = someLoaders;
    }

    protected static String serializeURL(URL location) {
        String str3;
        String str2;
        StringBuilder localStringBuilder = new StringBuilder(128);
        String str1 = location.getProtocol();
        if (str1 != null) {
            str1 = str1.toLowerCase();
            localStringBuilder.append(str1);
            localStringBuilder.append("://");
        }
        if ((str2 = location.getHost()) != null) {
            str2 = str2.toLowerCase();
            localStringBuilder.append(str2);
            int i = location.getPort();
            if (i == -1) {
                i = location.getDefaultPort();
            }
            if (i != -1) {
                localStringBuilder.append(":").append(i);
            }
        }
        if ((str3 = location.getFile()) != null) {
            localStringBuilder.append(str3);
        }
        return localStringBuilder.toString();
    }

    public boolean close(URL location) throws IOException {
        Object loader;
        if (this.index.isEmpty()) {
            return false;
        }
        Object firstKey = this.index.keySet().iterator().next();
        Object obj = loader = firstKey instanceof URL ? this.index.remove(location) : this.index.remove(URLClassLoaderCloser.serializeURL(location));
        if (loader == null) {
            return false;
        }
        this.loaders.remove(loader);
        JarFile jar = null;
        try {
            jar = (JarFile)this.introspector.jarField.get(loader);
            this.introspector.jarField.set(loader, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot use reflection on url class path", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot use reflection on url class path", e);
        }
        jar.close();
        return true;
    }
}

