/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.CodingStyleguideUnaware;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import com.phloc.commons.xml.EXMLParserFeatureType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public enum EXMLParserFeature implements IHasName
{
    NAMESPACES(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/namespaces"),
    USE_ENTITY_RESOLVER2(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/use-entity-resolver2"),
    VALIDATION(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/validation"),
    DYNAMIC(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/dynamic"),
    SCHEMA(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema"),
    SCHEMA_FULL_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema-full-checking"),
    NORMALIZED_VALUE(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/normalized-value"),
    ELEMENT_DEFAULT(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/element-default"),
    AUGMENT_PSVI(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/augment-psvi"),
    IGNORE_XSI_TYPE_UNTIL_ELEMDECL(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/schema/ignore-xsi-type-until-elemdecl"),
    GENERATE_SYNTHETIC_ANNOTATIONS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/generate-synthetic-annotations"),
    VALIDATE_ANNOTATIONS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validate-annotations"),
    HONOUR_ALL_SCHEMA_LOCATIONS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/honour-all-schemaLocations"),
    EXTERNAL_GENERAL_ENTITIES(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/external-general-entities"),
    EXTERNAL_PARAMETER_ENTITIES(EXMLParserFeatureType.GENERAL, "http://xml.org/sax/features/external-parameter-entities"),
    BALANCE_SYNTAX_TREES(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/balance-syntax-trees"),
    ID_IDREF_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/id-idref-checking"),
    IDENTITY_CONSTRAINT_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/identity-constraint-checking"),
    UNPARSED_ENTITY_CHECKING(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/unparsed-entity-checking"),
    WARN_ON_DUPLICATE_ATTDEF(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/warn-on-duplicate-attdef"),
    WARN_ON_UNDECLARED_ELEMDEF(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef"),
    WARN_ON_DUPLICATE_ENTITYDEF(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/warn-on-duplicate-entitydef"),
    XINCLUDE(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/xinclude"),
    XINCLUDE_FIXUP_BASE_URIS(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/xinclude/fixup-base-uris"),
    XINCLUDE_FIXUP_LANGUAGE(EXMLParserFeatureType.GENERAL, "http://apache.org/xml/features/xinclude/fixup-language"),
    SAX_NAMESPACE_PREFIXES(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/namespace-prefixes"),
    SAX_FEATURE_IS_STANDALONE(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/is-standalone"),
    SAX_USE_ATTRIBUTES2(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/use-attributes2"),
    SAX_USE_LOCATOR2(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/use-locator2"),
    SAX_IS_XML11_PARSER(EXMLParserFeatureType.SAX, "http://xml.org/sax/features/xml-1.1");

    private static final Logger s_aLogger;
    private final EXMLParserFeatureType m_eType;
    private final String m_sName;
    @CodingStyleguideUnaware
    private boolean m_bWarnedOnce = false;

    private EXMLParserFeature(EXMLParserFeatureType eXMLParserFeatureType, String string2) {
        this.m_eType = eXMLParserFeatureType;
        this.m_sName = string2;
    }

    @Nonnull
    public EXMLParserFeatureType getFeatureType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public void applyTo(@Nonnull XMLReader xMLReader, boolean bl) {
        ValueEnforcer.notNull(xMLReader, "Parser");
        if (this.m_eType != EXMLParserFeatureType.GENERAL && this.m_eType != EXMLParserFeatureType.SAX) {
            s_aLogger.warn("Parser feature '" + this.name() + "' is not applicable for SAX parsers!");
        }
        try {
            xMLReader.setFeature(this.m_sName, bl);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            if (!this.m_bWarnedOnce) {
                s_aLogger.warn("XML Parser does not recognize feature '" + this.name() + "'");
                this.m_bWarnedOnce = true;
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            s_aLogger.warn("XML Parser does not support feature '" + this.name() + "'");
        }
    }

    public void applyTo(@Nonnull DocumentBuilderFactory documentBuilderFactory, boolean bl) {
        ValueEnforcer.notNull(documentBuilderFactory, "DocumentBuilderFactory");
        if (this.m_eType != EXMLParserFeatureType.GENERAL && this.m_eType != EXMLParserFeatureType.DOM) {
            s_aLogger.warn("Parser feature '" + this.name() + "' is not applicable for DOM parsers!");
        }
        try {
            documentBuilderFactory.setFeature(this.m_sName, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            s_aLogger.warn("DOM parser does not support feature '" + this.name() + "'");
        }
    }

    @Nullable
    public static EXMLParserFeature getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EXMLParserFeature.class, string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<EXMLParserFeature> getAllFeaturesOfType(@Nonnull EXMLParserFeatureType eXMLParserFeatureType) {
        ValueEnforcer.notNull(eXMLParserFeatureType, "FeatureType");
        ArrayList<EXMLParserFeature> arrayList = new ArrayList<EXMLParserFeature>();
        for (EXMLParserFeature eXMLParserFeature : EXMLParserFeature.values()) {
            if (eXMLParserFeature.getFeatureType() != eXMLParserFeatureType) continue;
            arrayList.add(eXMLParserFeature);
        }
        return arrayList;
    }

    static {
        s_aLogger = LoggerFactory.getLogger(EXMLParserFeature.class);
    }
}

