/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.transaction.io;

import fr.toutatice.ecm.platform.automation.transaction.io.OperationResultType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

public class PreMessageBodyWriter {
    private static final Log log = LogFactory.getLog(PreMessageBodyWriter.class);

    private PreMessageBodyWriter() {
    }

    public static void prepareResult(Object result) {
        if (result != null) {
            OperationResultType type = OperationResultType.getType(result);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preparing: " + result.toString()));
                log.debug((Object)("Type: " + (Object)((Object)type)));
            }
            if (type != null) {
                switch (type) {
                    case document: {
                        DocumentModel doc = (DocumentModel)result;
                        PreMessageBodyWriter.refreshDocument(doc);
                        break;
                    }
                    case documents: {
                        DocumentModelList docs = (DocumentModelList)result;
                        for (DocumentModel doc_ : docs) {
                            PreMessageBodyWriter.refreshDocument(doc_);
                        }
                        break;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(result.toString() + " prepared"));
            }
        }
    }

    private static void refreshDocument(DocumentModel doc) {
        doc.refresh(293, doc.getSchemas());
        doc.getLockInfo();
    }
}

