/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.dublincore.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class DublinCoreStorageService
extends DefaultComponent {
    public static Log log = LogFactory.getLog(DublinCoreStorageService.class);
    public static final String ID = "DublinCoreStorageService";

    public void setCreationDate(DocumentModel doc, Calendar creationDate, Event event) {
        try {
            doc.setProperty("dublincore", "created", (Object)creationDate);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        this.addContributor(doc, event);
    }

    public void setModificationDate(DocumentModel doc, Calendar modificationDate, Event event) {
        try {
            doc.setProperty("dublincore", "modified", (Object)modificationDate);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        try {
            if (doc.getProperty("dublincore", "created") == null) {
                this.setCreationDate(doc, modificationDate, event);
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void addContributor(DocumentModel doc, Event event) {
        String[] contributorsArray;
        Principal principal = event.getContext().getPrincipal();
        if (principal == null) {
            return;
        }
        String principalName = principal.getName();
        if (principal instanceof SystemPrincipal) {
            SystemPrincipal nxp = (SystemPrincipal)principal;
            String originatingUser = nxp.getOriginatingUser();
            if ((originatingUser == null || "system".equals(originatingUser)) && !"documentCreated".equals(event.getName())) {
                return;
            }
            principalName = originatingUser;
        }
        try {
            contributorsArray = (String[])doc.getProperty("dublincore", "contributors");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        List<Object> contributorsList = new ArrayList();
        if (contributorsArray != null && contributorsArray.length > 0) {
            contributorsList = Arrays.asList(contributorsArray);
            contributorsList = new ArrayList(contributorsList);
        } else {
            SchemaManager schemaMgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            if (schemaMgr.getSchema("dublincore").getField("creator") != null) {
                try {
                    doc.setProperty("dublincore", "creator", (Object)principalName);
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException((Throwable)e);
                }
            }
        }
        if (!contributorsList.contains(principalName)) {
            contributorsList.add(principalName);
            String[] contributorListIn = new String[contributorsList.size()];
            contributorsList.toArray(contributorListIn);
            try {
                doc.setProperty("dublincore", "contributors", (Object)contributorListIn);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        try {
            doc.setProperty("dublincore", "lastContributor", (Object)principalName);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setIssuedDate(DocumentModel doc, Calendar issuedDate) {
        try {
            doc.setPropertyValue("dc:issued", (Serializable)issuedDate);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

