/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenStore;

public class NuxeoOAuth2ServiceProvider {
    public static final String SCHEMA = "oauth2ServiceProvider";
    protected String serviceName;
    protected Long id;
    private String tokenServerURL;
    private String authorizationServerURL;
    private String clientId;
    private String clientSecret;
    private List<String> scopes;

    public NuxeoOAuth2ServiceProvider(Long id, String serviceName, String tokenServerURL, String authorizationServerURL, String clientId, String clientSecret, List<String> scopes) {
        this.id = id;
        this.serviceName = serviceName;
        this.tokenServerURL = tokenServerURL;
        this.authorizationServerURL = authorizationServerURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = scopes;
    }

    public static NuxeoOAuth2ServiceProvider createFromDirectoryEntry(DocumentModel entry) throws ClientException {
        String authorizationServerURL = (String)entry.getProperty(SCHEMA, "authorizationServerURL");
        String tokenServerURL = (String)entry.getProperty(SCHEMA, "tokenServerURL");
        Long id = (Long)entry.getProperty(SCHEMA, "id");
        String serviceName = (String)entry.getProperty(SCHEMA, "serviceName");
        String clientId = (String)entry.getProperty(SCHEMA, "clientId");
        String clientSecret = (String)entry.getProperty(SCHEMA, "clientSecret");
        String scopes = (String)entry.getProperty(SCHEMA, "scopes");
        return new NuxeoOAuth2ServiceProvider(id, serviceName, tokenServerURL, authorizationServerURL, clientId, clientSecret, Arrays.asList(scopes.split(",")));
    }

    protected DocumentModel asDocumentModel(DocumentModel entry) throws ClientException {
        entry.setProperty(SCHEMA, "serviceName", (Object)this.serviceName);
        entry.setProperty(SCHEMA, "authorizationServerURL", (Object)this.authorizationServerURL);
        entry.setProperty(SCHEMA, "tokenServerURL", (Object)this.tokenServerURL);
        entry.setProperty(SCHEMA, "clientId", (Object)this.clientId);
        entry.setProperty(SCHEMA, "clientSecret", (Object)this.clientSecret);
        entry.setProperty(SCHEMA, "scopes", (Object)StringUtils.join(this.scopes, (String)","));
        return entry;
    }

    public AuthorizationCodeFlow getAuthorizationCodeFlow(HttpTransport transport, JsonFactory jsonFactory) {
        Credential.AccessMethod method = BearerToken.authorizationHeaderAccessMethod();
        GenericUrl tokenServerUrl = new GenericUrl(this.tokenServerURL);
        ClientParametersAuthentication clientAuthentication = new ClientParametersAuthentication(this.clientId, this.clientSecret);
        String authorizationServerUrl = this.authorizationServerURL;
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(method, transport, jsonFactory, tokenServerUrl, (HttpExecuteInterceptor)clientAuthentication, this.clientId, authorizationServerUrl).setScopes(this.scopes).setCredentialStore(this.getCredentialStore()).build();
        return flow;
    }

    public CredentialStore getCredentialStore() {
        return new OAuth2TokenStore(this.serviceName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Long getId() {
        return this.id;
    }

    public String getTokenServerURL() {
        return this.tokenServerURL;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getAuthorizationServerURL() {
        return this.authorizationServerURL;
    }
}

