/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.cas.pronote;

import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.osivia.cas.pronote.PronoteCasClientCredential;
import org.springframework.webflow.execution.RequestContext;

public class PronoteCasClientAction
extends AbstractNonInteractiveCredentialsAction {
    public PronoteCasClientAction(CentralAuthenticationService theCentralAuthenticationService) {
        this.setCentralAuthenticationService(theCentralAuthenticationService);
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        String serviceTicket = context.getRequestParameters().get("ticket");
        String casName = context.getRequestParameters().get("casName");
        String serviceUrl = context.getRequestParameters().get("service");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("About to validate serviceTickat " + serviceTicket + " for " + serviceUrl + " to " + casName);
        }
        PronoteCasClientCredential credential = null;
        if (StringUtils.isNotBlank((CharSequence)casName) && StringUtils.isNotBlank((CharSequence)serviceTicket)) {
            credential = new PronoteCasClientCredential();
            credential.setServiceTicket(serviceTicket);
            credential.setCasName(casName);
            credential.setServiceUrl(serviceUrl);
        } else {
            this.logger.error("urlCAS, ticket and service url are mandatory.");
        }
        return credential;
    }
}

