/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.cas.pronote;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jasig.cas.authentication.AbstractAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.principal.Principal;
import org.ldaptive.LdapException;
import org.ldaptive.auth.DnResolver;
import org.osivia.cas.pronote.PronoteCasClientCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PronoteCasClientHandler
extends AbstractAuthenticationHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DnResolver dnResolverForClient;
    private String casValidateUrl;

    public PronoteCasClientHandler(DnResolver dnResolverForClient) {
        this.dnResolverForClient = dnResolverForClient;
    }

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("authenticate");
        }
        PronoteCasClientCredential pronoteCredential = null;
        if (credential == null) {
            this.logger.error("credential is null");
            throw new GeneralSecurityException("credential is null");
        }
        pronoteCredential = (PronoteCasClientCredential)credential;
        try {
            if (!pronoteCredential.getCasName().equals("pronote")) {
                throw new GeneralSecurityException("Upstream Cas name " + pronoteCredential.getCasName() + " unknown");
            }
            CloseableHttpClient client = HttpClientBuilder.create().build();
            URIBuilder builder = new URIBuilder(this.casValidateUrl);
            builder.setParameter("ticket", pronoteCredential.getServiceTicket());
            builder.setParameter("service", pronoteCredential.getServiceUrl());
            HttpGet request = new HttpGet(builder.build());
            request.addHeader("User-Agent", "Cloud-ens");
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GET " + request.getURI().toASCIIString() + " returned HTTP " + statusCode);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("analyse response ");
            }
            if (statusCode == 200) {
                String resolve;
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                String xml = EntityUtils.toString((HttpEntity)response.getEntity());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("response " + xml);
                }
                Document casResponse = docBuilder.parse(new InputSource(new StringReader(xml)));
                Element root = casResponse.getDocumentElement();
                String casUser = null;
                for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
                    Node item = root.getChildNodes().item(i);
                    if (item.getNodeType() != 1 || !item.getNodeName().equals("cas:authenticationSuccess")) continue;
                    for (int j = 0; j < item.getChildNodes().getLength(); ++j) {
                        Node item2 = item.getChildNodes().item(j);
                        if (item2.getNodeType() != 1 || !item2.getNodeName().equals("cas:user")) continue;
                        for (int k = 0; k < item2.getChildNodes().getLength(); ++k) {
                            Node item3 = item2.getChildNodes().item(k);
                            casUser = item3.getNodeValue();
                        }
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Response :  " + docBuilder.toString());
                }
                if ((resolve = this.dnResolverForClient.resolve(casUser)) != null) {
                    Principal principal = this.principalFactory.createPrincipal(casUser);
                    BasicCredentialMetaData metaData = new BasicCredentialMetaData(credential);
                    ArrayList warnings = new ArrayList();
                    return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)metaData, principal, warnings);
                }
                throw new GeneralSecurityException("Unknown user " + casUser);
            }
            throw new GeneralSecurityException("Server returned a non-ok response " + response.getEntity().toString());
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException | ParserConfigurationException | LdapException | SAXException e) {
            throw new PreventedException(e);
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof PronoteCasClientCredential;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }
}

