/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartographie.portail.cartographie.beans;

import fr.toutatice.cartographie.portail.cartographie.beans.Point;
import java.io.Serializable;

public class Bounds
implements Serializable {
    private double southWestLng;
    private double southWestLat;
    private double northEastLng;
    private double northEastLat;

    public Bounds() {
    }

    public Bounds(String bounds) {
        String[] split = bounds.split(",");
        this.setSouthWestLon(Double.parseDouble(split[0]));
        this.setSouthWestLat(Double.parseDouble(split[1]));
        this.setNorthEastLon(Double.parseDouble(split[2]));
        this.setNorthEastLat(Double.parseDouble(split[3]));
    }

    public Bounds(Point point) {
        this.setSouthWestLat(point.getLat().doubleValue());
        this.setSouthWestLon(point.getLon().doubleValue());
        this.setNorthEastLat(point.getLat().doubleValue());
        this.setNorthEastLon(point.getLon().doubleValue());
    }

    public Bounds(Point ... points) {
        this(points[0]);
        for (Point point : points) {
            this.extend(new Point[]{point});
        }
    }

    public double getSouthWestLon() {
        return this.southWestLng;
    }

    public void setSouthWestLon(double southWestLng) {
        this.southWestLng = southWestLng;
    }

    public double getSouthWestLat() {
        return this.southWestLat;
    }

    public void setSouthWestLat(double southWestLat) {
        this.southWestLat = southWestLat;
    }

    public double getNorthEastLon() {
        return this.northEastLng;
    }

    public void setNorthEastLon(double northEastLng) {
        this.northEastLng = northEastLng;
    }

    public double getNorthEastLat() {
        return this.northEastLat;
    }

    public void setNorthEastLat(double northEastLat) {
        this.northEastLat = northEastLat;
    }

    public void extend(Point ... points) {
        for (Point point : points) {
            this.setNorthEastLat(Math.max(this.getNorthEastLat(), point.getLat()));
            this.setNorthEastLon(Math.max(this.getNorthEastLon(), point.getLon()));
            this.setSouthWestLat(Math.min(this.getSouthWestLat(), point.getLat()));
            this.setSouthWestLon(Math.min(this.getSouthWestLon(), point.getLon()));
        }
    }

    public Point getCenter() {
        return new Point((this.getNorthEastLat() + this.getSouthWestLat()) / 2.0, (this.getNorthEastLon() + this.getSouthWestLon()) / 2.0);
    }
}

