/*
 * (C) Copyright 2014 Académie de Rennes (http://www.ac-rennes.fr/) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 *
 * Contributors:
 *  aguihomat
 *
 *
 */
package fr.toutatice.cartographie.portail.cartographie;






import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.portal.api.sequencing.IPortletSequencingService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;



@Controller
@RequestMapping("VIEW")
@SessionAttributes({"zoom","center"})

public class CartoController extends PortalGenericPortlet implements PortletContextAware, PortletConfigAware {

	protected static final Log logger = LogFactory.getLog("fr.toutatice.services");

    private static final String FLUX_JSON = "fluxGeoJson";

    /** portletContext */
	private PortletContext portletContext;
    /** Portlet config. */
    private PortletConfig portletConfig;

    /** portletSequencingService */
    private IPortletSequencingService portletSequencingService;

    /**
     * Portlet initialization.
     *
     * @throws PortletException
     */
    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(portletConfig);
        portletSequencingService = Locator.findMBean(IPortletSequencingService.class, IPortletSequencingService.MBEAN_NAME);
    }


	@RequestMapping
	public String accueil(RenderRequest request, PortletSession session, RenderResponse response) throws InterruptedException {

        final boolean newFlux = false;

		//Récupération du flux geojson renseigné dans la vue admin
		final PortalWindow window = WindowFactory.getWindow(request);
		String fluxGeoJsonAdmin = window.getProperty("toutatice.cartographie.fluxgeojsonAdmin");
		if(fluxGeoJsonAdmin==null){
			fluxGeoJsonAdmin="";
		}

        // Nuxeo controller
        final NuxeoController nuxeoController = new NuxeoController(request, response, this.getPortletContext());

        // Portal controller context
        final PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();

        String fluxGeoJson;
        if (StringUtils.isNotEmpty(fluxGeoJsonAdmin)) {
            fluxGeoJson = fluxGeoJsonAdmin;
        } else {
            fluxGeoJson = (String) portletSequencingService.getAttribute(portalControllerContext, FLUX_JSON);
        }

		//Récupération des paramètres par défaut
        this.setParamCartes(request, session, newFlux);

        request.setAttribute(FLUX_JSON, fluxGeoJson);

		return "carte";

	}


	@ActionMapping(params = "action=ensavoirplus")
	public void redirect(@RequestParam String urlRedirect, @RequestParam String zoom, @RequestParam String center, ActionResponse response,  ActionRequest request, PortletSession session) throws Exception {

		final PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, request, response);
		final NuxeoController nuxeoCtl = new NuxeoController(request, null, portletContext);

		if(zoom!=null){
			session.setAttribute("zoom", zoom);
		}
		if(center!=null){
			session.setAttribute("center", center);
		}


		final String url = nuxeoCtl.getPortalUrlFactory().adaptPortalUrlToNavigation(portalControllerContext, urlRedirect);

		request.setAttribute(Constants.PORTLET_ATTR_REDIRECTION_URL, url);

	}


	public void setParamCartes(RenderRequest request, PortletSession session, boolean newFlux){

		final PortalWindow window = WindowFactory.getWindow(request);
		final String latitudeRef = window.getProperty("toutatice.cartographie.latitudeRef");
		final String longitudeRef = window.getProperty("toutatice.cartographie.longitudeRef");
		int zoomRef=0;
		if(window.getProperty("toutatice.cartographie.zoomRef")!=null){
			zoomRef = Integer.parseInt(window.getProperty("toutatice.cartographie.zoomRef"));
		}
		int zoomMax=0;
		if(window.getProperty("toutatice.cartographie.zoomMax")!=null){
			zoomMax = Integer.parseInt(window.getProperty("toutatice.cartographie.zoomMax"));
		}
		int zoomMin=0;
		if(window.getProperty("toutatice.cartographie.zoomMin")!=null){
			zoomMin = Integer.parseInt(window.getProperty("toutatice.cartographie.zoomMin"));
		}
		String maxBoundsNorthEast="";
		String maxBoundsSouthWest="";

		if(window.getProperty("toutatice.cartographie.maxBoundsSouthWest")!=null){
			maxBoundsSouthWest = window.getProperty("toutatice.cartographie.maxBoundsSouthWest");
		}
		if(window.getProperty("toutatice.cartographie.maxBoundsNorthEast")!=null){
			maxBoundsNorthEast = window.getProperty("toutatice.cartographie.maxBoundsNorthEast");
		}
		String fitbounds = "false";
		if(window.getProperty("toutatice.cartographie.fitbounds")!=null){
			fitbounds = window.getProperty("toutatice.cartographie.fitbounds");
		}


		if(zoomMax<7){
			zoomMax = 20;
		}
		if(zoomMin<7){
			zoomMin = 7;
		}
		if((zoomRef>zoomMax)||(zoomRef<zoomMin)){
			zoomRef=zoomMin;
		}

		//Restauration carte


		String center = (String) session.getAttribute("center");
		final String zoom = (String) session.getAttribute("zoom");

		if(!newFlux && (center!=null)&&(zoom!=null)){

			zoomRef =  Integer.parseInt(zoom);
			center = center.replace("LatLng(", "");
			center = center.replace(")","");
			final String[]centerTab = center.split(",");
			request.setAttribute("center1", centerTab[0]);
			request.setAttribute("center2", centerTab[1]);

		}else{
			session.removeAttribute("zoom");
			session.removeAttribute("center");
		}


		request.setAttribute("latitudeRef", latitudeRef);
		request.setAttribute("longitudeRef", longitudeRef);
		request.setAttribute("zoomRef",zoomRef);
		request.setAttribute("zoomMax",zoomMax);
		request.setAttribute("zoomMin",zoomMin);
		request.setAttribute("maxBoundsSouthWest", maxBoundsSouthWest);
		request.setAttribute("maxBoundsNorthEast", maxBoundsNorthEast);
		request.setAttribute("fitbounds",fitbounds);

	}


	@Override
    public void setPortletContext(PortletContext portletContext) {
		this.portletContext = portletContext;
	}

    /**
     * {@inheritDoc}
     */
    @Override
    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}
