<!DOCTYPE html>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>


<html>

<head>
    <title><op:translate key="ERROR" /> - <op:translate key="BRAND" /></title>

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="default-style" content="Cartoun">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    
    <link rel="stylesheet" href="/osivia-portal-custom-web-assets/css/osivia.min.css">
    <link rel="stylesheet" href="/osivia-portal-custom-web-assets/css/noscript.min.css">
    <link rel="stylesheet" href="/osivia-portal-custom-web-assets/components/glyphicons/css/glyphicons.min.css">
    <link rel="stylesheet" href="/osivia-portal-custom-web-assets/components/glyphicons/css/glyphicons-halflings.min.css">
    <link rel="stylesheet" href="/cartoun-charte/css/cartoun.min.css" title="Cartoun" />
</head>


<body>
    <!-- Toolbar -->
    <div class="toolbar">
        <div class="navbar navbar-default navbar-fixed-top">
            <div class="container-fluid">
                <div class="navbar-header">
                    <div class="visible-xs">
                        <!-- Title -->
                        <div class="clearfix">
                            <p class="navbar-text text-overflow"><op:translate key="ERROR" /></p>
                        </div>
                    </div>
                    
                    <!-- Brand -->
                    <a class="navbar-brand hidden-xs" href="/"><op:translate key="BRAND" /></a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Header -->
    <header>
        <div class="container-fluid">
            <!-- Tabs -->
            <div class="tabs-custom">
                <!-- Fixed nav -->
                <nav role="navigation" class="tabs tabs-default">
                    <!-- Title -->
                    <h2 class="hidden"><op:translate key="TABS_TITLE" /></h2>
                    
                    <!-- Home -->
                    <div class="pull-left">
                        <ul class="home">
                            <li class="active" role="presentation">
                                <a href="/">
                                    <i class="halflings halflings-home"></i>
                                    <span class="sr-only"><op:translate key="HOME" /></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
    </header>
    
    <!-- Page content -->
    <div id="page-content" class="container-fluid">
        <div class="alert alert-danger" role="alert">
            <i class="glyphicons halflings exclamation-sign"></i>
            
            <c:choose>
                <c:when test="${(param['httpCode'] eq 401) || (param['httpCode'] eq 403) || (param['httpCode'] eq 404)}">
                    <span><op:translate key="ERROR_${param['httpCode']}" /></span>
                </c:when>

                <c:otherwise>
                    <span><op:translate key="ERROR_GENERIC_MESSAGE" /></span>
                </c:otherwise>
            </c:choose>
        </div>
    </div>
    
    <!-- Footer -->
    <footer></footer>
</body>

</html>
