<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>


<c:set var="userPortal" value="${requestScope['osivia.userPortal']}" />
<c:set var="userPages" value="${userPortal.userPages}" />


<div class="visible-xs clearfix">
    <div class="col-xs-12 drawer-toolbar-header">
        <div>        
            <!-- Title -->
            <div class="drawer-toolbar-title">
                <div class="clearfix">
                    <div class="pull-left">
                        <p class="text-overflow">
                            <c:choose>
                                <c:when test="${not empty userPortal.defaultPage}">
                                    <a href="${userPortal.defaultPage.url}">${requestScope['osivia.header.application.name']}</a>
                                </c:when>
                                
                                <c:otherwise>
                                    <span>${requestScope['osivia.header.application.name']}</span>
                                </c:otherwise>
                            </c:choose>
                        </p>
                    </div>
                    
                    <div class="pull-right text-nowrap">
                        <c:choose>
                            <c:when test="${empty requestScope['osivia.toolbar.principal']}">
                                <a href="${requestScope['osivia.toolbar.loginURL']}" class="btn btn-link">
                                    <i class="halflings halflings-log-in"></i>
                                </a>
                            </c:when>
                            
                            <c:otherwise>
                                <div class="btn-group dropdown">
                                    <button type="button" class="btn btn-link dropdown-toggle" data-toggle="dropdown">
                                        <i class="glyphicons glyphicons-user"></i>
                                        <small><i class="halflings halflings-triangle-bottom"></i></small>
                                    </button>
    
                                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                    
                                    	<li role="presentation" class="dropdown-header"><span>${requestScope['osivia.toolbar.person'].displayName}</span></li>
                                        
                                        <c:if test="${not empty requestScope['acrennes.sites.cartoun.fichePersonnePage.url']}">
	                                	<li role="presentation">
		                                    <a href="${requestScope['acrennes.sites.cartoun.fichePersonnePage.url']}" role="menuitem">
		                                        <i class="halflings halflings-user"></i>
		                                        <span><op:translate key="FICHE_PERSONNE" /></span>
		                                    </a>
		                                </li>
                                	</c:if>
                                	
                                	<c:if test="${not empty requestScope['acrennes.sites.cartoun.disciplinesPage.url']}">
	                                	<li role="presentation">
		                                    <a href="${requestScope['acrennes.sites.cartoun.disciplinesPage.url']}" role="menuitem">
		                                        <i class="halflings halflings-cog"></i>
		                                        <span><op:translate key="REGLAGE_DISCIPLINES" /></span>
		                                    </a>
		                                </li>
                                	</c:if>
                                	
                                	<c:if test="${not empty requestScope['acrennes.sites.cartoun.ficheProfilPage.url']}">
	                                	<li role="presentation">
		                                    <a href="${requestScope['acrennes.sites.cartoun.ficheProfilPage.url']}" role="menuitem">
		                                        <i class="glyphicons glyphicons-group"></i>
		                                        <span><op:translate key="FICHE_PROFIL" /></span>
		                                    </a>
		                                </li>
                                	</c:if>
                                        
                                        <li role="presentation">
                                            <a href="#" onclick="logout()" role="menuitem">
                                                <i class="halflings halflings-log-out"></i>
                                                <span><op:translate key="LOGOUT" /></span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </c:otherwise>
                        </c:choose>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <c:if test="${not requestScope['osivia.spaceSite']}">
        <div class="col-xs-12 drawer-toolbar-tabs">
            <div class="dropdown">
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                    <span class="pull-right"><small><i class="halflings halflings-triangle-bottom"></i></small></span>
                    <span class="text-overflow">${requestScope['osivia.currentPageName']}</span>
                </button>
                
                <ul class="dropdown-menu" role="menu">
                    <c:if test="${not empty requestScope['osivia.currentPageURL']}">
                        <!-- Tab home -->
                        <li role="presentation">
                            <a href="${requestScope['osivia.currentPageURL']}" class="text-overflow" role="menuitem">
                                <i class="halflings halflings-home"></i>
                                <span>${requestScope['osivia.currentPageName']}</span>
                            </a>
                        </li>
                        
                        <!-- Divider -->
                        <li class="divider" role="presentation"></li>
                    </c:if>
                
                    <!-- Portal home -->
                    <c:if test="${not empty userPortal.defaultPage}">
                        <li role="presentation"
                            <c:if test="${userPortal.defaultPage.id eq requestScope['osivia.currentPageId']}">class="active"</c:if>
                        >
                            <a href="${userPortal.defaultPage.url}" class="text-overflow" role="menuitem">
                                <span>${userPortal.defaultPage.name}</span>
                            </a>
                        </li>
                    </c:if>
                
                    <c:forEach var="userPage" items="${userPages}">
                        <c:if test="${not userPage.defaultPage}">
                            <li role="presentation"
                                <c:if test="${userPage.id eq requestScope['osivia.currentPageId']}">class="active"</c:if>
                            >
                                <a href="${userPage.url}" class="text-overflow" role="menuitem">${userPage.name}</a>
                            </li>
                        </c:if>
                    </c:forEach>
                </ul>
            </div>
        </div>
    </c:if>
</div>
