/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.customizer.attributes;

import fr.toutatice.cartoun.customizer.attributes.CustomToolbarAttributesBundle;
import fr.toutatice.cartoun.customizer.attributes.CustomizedAttributesBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.theming.IAttributesBundle;

public class AttributesCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "cartoun.customizer.attributes";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    private final List<IAttributesBundle> bundles = new ArrayList();
    private ICustomizationModulesRepository repository;

    public AttributesCustomizer() {
        this.bundles.add(CustomizedAttributesBundle.getInstance());
        this.bundles.add(CustomToolbarAttributesBundle.getInstance());
    }

    private final CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.attributesBundles.id"));
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        Map attributes = context.getAttributes();
        String name = (String)attributes.get("osivia.customizer.attributesBundles.name");
        for (IAttributesBundle bundle : this.bundles) {
            if (!bundle.getAttributeNames().contains(name)) continue;
            attributes.put("osivia.customizer.attributesBundles.result", bundle);
            break;
        }
    }
}

