package fr.toutatice.cartoun.customizer.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.theming.UserPage;
import org.osivia.portal.api.theming.UserPagesGroup;
import org.osivia.portal.api.theming.UserPortal;



public class SortTabsAttributesBundle implements IAttributesBundle {

    private static final String TABS_GROUPS = "acrennes.sites.cartoun.tabs.groups.hiddenPages";
    private static final String TABS_GROUPS_1 = TABS_GROUPS + ".1";
    private static final String TABS_GROUPS_2 = TABS_GROUPS + ".2";

    /** Toolbar attributes names. */
    private final Set<String> names;


    /**
     * Singleton Holder
     */
    private static class SortTabsAttributesBundleHolder {

        private static final SortTabsAttributesBundle INSTANCE = new SortTabsAttributesBundle();
    }

    /**
     * Singleton instance access.
     *
     * @return singleton instance
     */
    public static SortTabsAttributesBundle getInstance() {
        return SortTabsAttributesBundleHolder.INSTANCE;
    }

    private SortTabsAttributesBundle() {
        super();
        // Attributes names
        this.names = new HashSet<String>();
        names.add(TABS_GROUPS_1);
        names.add(TABS_GROUPS_2);
    }

    @Override
    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        UserPortal userPortal = (UserPortal) attributes.get("osivia.userPortal");
        if (userPortal != null) {
            UserPagesGroup cartoGroup = userPortal.getGroup("cartography");
            if ((cartoGroup != null) && (cartoGroup.getHiddenPages() != null)) {
                List<UserPageComparable> hiddenPagesSorted = new ArrayList<UserPageComparable>(cartoGroup.getHiddenPages().size());
                for (UserPage hiddenPage : cartoGroup.getHiddenPages()) {
                    hiddenPagesSorted.add(new UserPageComparable(hiddenPage));
                }
                Collections.sort(hiddenPagesSorted);
                int midPoint = (hiddenPagesSorted.size() % 2) == 0 ? hiddenPagesSorted.size() / 2 : (hiddenPagesSorted.size() / 2) + 1;
                List<UserPageComparable> hiddenPagesSorted1 = hiddenPagesSorted.subList(0, midPoint - 1);
                List<UserPageComparable> hiddenPagesSorted2 = hiddenPagesSorted.subList(midPoint, hiddenPagesSorted.size() - 1);

                attributes.put(TABS_GROUPS_1, hiddenPagesSorted1);
                attributes.put(TABS_GROUPS_2, hiddenPagesSorted2);
            }
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        return names;
    }

}
